@extends('layouts.admin')

@section('title', 'Refunds Report')

@section('content')
    <div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">
        <!-- Page header -->
        <div class="sm:flex sm:justify-between sm:items-center mb-8">
            <div class="mb-4 sm:mb-0">
                <h1 class="text-2xl md:text-3xl text-gray-800 font-bold">Refunds Report</h1>
            </div>
            <div class="grid grid-flow-col sm:auto-cols-max justify-start sm:justify-end gap-2">
                <!-- Filter Form -->
                <form action="{{ route('admin.reports.refunds') }}" method="GET" class="flex gap-2">
                    <select name="month" class="form-select border-gray-300 rounded-md">
                        <option value="">All Months</option>
                        @foreach(range(1, 12) as $m)
                            <option value="{{ $m }}" {{ request('month') == $m ? 'selected' : '' }}>
                                {{ date('F', mktime(0, 0, 0, $m, 1)) }}</option>
                        @endforeach
                    </select>
                    <select name="year" class="form-select border-gray-300 rounded-md">
                        <option value="">All Years</option>
                        @foreach(range(date('Y'), date('Y') - 5) as $y)
                            <option value="{{ $y }}" {{ request('year') == $y ? 'selected' : '' }}>{{ $y }}</option>
                        @endforeach
                    </select>
                    <button type="submit" name="action" value="filter"
                        class="btn bg-indigo-500 hover:bg-indigo-600 text-white">Filter</button>
                    <button type="submit" name="action" value="pdf" class="btn bg-red-500 hover:bg-red-600 text-white">
                        <svg class="w-4 h-4 fill-current opacity-50 shrink-0" viewBox="0 0 16 16">
                            <path
                                d="M15 15V5l-5-5H2c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h12c.6 0 1-.4 1-1zM9 1.5L13.5 6H9V1.5z" />
                        </svg>
                        <span class="ml-2">Export PDF</span>
                    </button>
                </form>
            </div>
        </div>

        <!-- Metrics -->
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 mb-8">
            <div
                class="flex flex-col col-span-full sm:col-span-6 xl:col-span-4 bg-white shadow-lg rounded-sm border border-gray-200">
                <header class="px-5 py-4 border-b border-gray-100 flex items-center">
                    <h2 class="font-semibold text-gray-800">Refund Summary</h2>
                </header>
                <div class="px-5 py-3">
                    <div class="flex items-start">
                        <div class="text-3xl font-bold text-gray-800 mr-2">
                            ₹{{ number_format($returns->sum('refund_amount'), 2) }}</div>
                        <div class="text-sm font-semibold text-green-500 px-1.5 bg-green-50 rounded-full">Total Refunded
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Table -->
        <div class="bg-white shadow-lg rounded-sm border border-gray-200">
            <div class="overflow-x-auto">
                <table class="table-auto w-full">
                    <thead class="text-xs font-semibold uppercase text-gray-500 bg-gray-50 border-b border-gray-100">
                        <tr>
                            <th class="p-2 whitespace-nowrap">
                                <div class="font-semibold text-left">Refund Date</div>
                            </th>
                            <th class="p-2 whitespace-nowrap">
                                <div class="font-semibold text-left">Order #</div>
                            </th>
                            <th class="p-2 whitespace-nowrap">
                                <div class="font-semibold text-left">Customer</div>
                            </th>
                            <th class="p-2 whitespace-nowrap">
                                <div class="font-semibold text-right">Order Amount</div>
                            </th>
                            <th class="p-2 whitespace-nowrap">
                                <div class="font-semibold text-right">Deduction</div>
                            </th>
                            <th class="p-2 whitespace-nowrap">
                                <div class="font-semibold text-right">Refund Amount</div>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="text-sm divide-y divide-gray-100">
                        @forelse($returns as $return)
                            <tr>
                                <td class="p-2 whitespace-nowrap text-gray-600">{{ $return->refunded_at->format('M d, Y') }}
                                </td>
                                <td class="p-2 whitespace-nowrap font-medium text-indigo-500"><a
                                        href="{{ route('admin.returns.show', $return->id) }}">#{{ $return->order->order_number }}</a>
                                </td>
                                <td class="p-2 whitespace-nowrap text-gray-800">{{ $return->user->name }}</td>
                                <td class="p-2 whitespace-nowrap text-right text-gray-600">
                                    ₹{{ number_format($return->order->total, 2) }}</td>
                                <td class="p-2 whitespace-nowrap text-right text-red-500">
                                    @if($return->deduction_amount > 0)
                                        -₹{{ number_format($return->deduction_amount, 2) }}
                                        <span class="text-xs block text-gray-400">({{ $return->deduction_reason }})</span>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="p-2 whitespace-nowrap text-right font-bold text-gray-800">
                                    ₹{{ number_format($return->refund_amount, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="p-4 text-center text-gray-500">No refunds found for the selected period.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="border-t border-gray-100 bg-gray-50">
                        <tr>
                            <td colspan="5" class="p-3 text-right font-bold text-gray-600 uppercase">Total</td>
                            <td class="p-3 text-right font-bold text-gray-900">
                                ₹{{ number_format($returns->sum('refund_amount'), 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection