<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Tax Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
        }

        .text-right {
            text-align: right;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 9px;
            color: #777;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Tax Report</h1>
        <p>Generated on: {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Order No</th>
                <th>Customer</th>
                <th>Tax Rate</th>
                <th class="text-right">Net Sales (Excl. Tax)</th>
                <th class="text-right">Tax (GST)</th>
                <th class="text-right">Total Sales</th>
            </tr>
        </thead>
        <tbody>
            @php 
                                                                                                                                $totalNet = 0;
                $totalTax = 0;
                $totalGross = 0;
            @endphp
 @foreach($orders as $order)
       @php 
                                                $groups = [];
        $orderShipping = $order->shipping_cost ?? 0;

        // Process Items
        if ($order->items) {
            foreach ($order->items as $item) {
                $itemGross = $item->price * $item->quantity;
                $storedTax = (float) $item->tax_amount;
                $storedRate = (float) $item->tax_rate;

                $itemTax = 0;
                $rate = 0;

                if ($storedTax > 0) {
                    $itemTax = $storedTax;
                    $rate = ($storedRate > 0) ? $storedRate : ($item->product ? ($item->product->tax_code ?? 18) : 18);
                } elseif (isset($settings) && $settings->product_tax_enabled) {
                    $rate = $item->product ? ($item->product->tax_code ?? 18) : 18;
                    $itemTax = $itemGross * ($rate / (100 + $rate));
                }

                $rateKey = (string) $rate;
                $itemNet = $itemGross - $itemTax;

                if (!isset($groups[$rateKey])) {
                    $groups[$rateKey] = ['rate' => $rate, 'net' => 0, 'tax' => 0, 'gross' => 0];
                }
                $groups[$rateKey]['net'] += $itemNet;
                $groups[$rateKey]['tax'] += $itemTax;
                $groups[$rateKey]['gross'] += $itemGross;
            }
        }

        // Add Shipping
        if ($orderShipping > 0) {
            $shippingTax = 0;
            $shippingNet = $orderShipping;
            $shippingLabel = 'Shipping';

            if ($order->shipping_tax_amount > 0) {
                $shippingTax = $order->shipping_tax_amount;
                $shippingNet = $orderShipping - $shippingTax;
                $rate = $order->shipping_tax_rate > 0 ? $order->shipping_tax_rate : 0;
                $shippingLabel = 'Shipping (' . (float) $rate . '%)';
            } elseif (isset($settings) && $settings->shipping_tax_enabled && isset($shippingTaxRate) && $shippingTaxRate > 0) {
                $shippingTax = $orderShipping * ($shippingTaxRate / (100 + $shippingTaxRate));
                $shippingNet = $orderShipping - $shippingTax;
                $shippingLabel = 'Shipping (' . (float) $shippingTaxRate . '%)';
            }

            $groups['Shipping'] = [
                'rate' => $shippingLabel,
                'net' => $shippingNet,
                'tax' => $shippingTax,
                'gross' => $orderShipping
            ];
        }

        ksort($groups);
        $rowCount = count($groups);
        if ($rowCount == 0)
            continue;
        $firstRow = true;
    @endphp

                @foreach($groups as $key => $data)
                    @php
                        $totalNet += $data['net'];
                        $totalTax += $data['tax'];
                        $totalGross += $data['gross'];
                    @endphp
                    <tr>
                        @if($firstRow)
                            <td rowspan="{{ $rowCount }}">{{ $order->created_at->format('Y-m-d') }}</td>
                            <td rowspan="{{ $rowCount }}">{{ $order->order_number }}</td>
                            <td rowspan="{{ $rowCount }}">{{ $order->user ? $order->user->name : ($order->name ?: 'Guest') }}</td>
                        @endif
                        <td>{{ is_numeric($data['rate']) ? $data['rate'] . '%' : $data['rate'] }}</td>
                        <td class="text-right">₹{{ number_format($data['net'], 2) }}</td>
                        <td class="text-right">₹{{ number_format($data['tax'], 2) }}</td>
                        <td class="text-right">₹{{ number_format($data['gross'], 2) }}</td>
                    </tr>
                    @php $firstRow = false; @endphp
                @endforeach
@endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="4" class="text-right"><strong>Total</strong></td>
                <td class="text-right"><strong>₹{{ number_format($totalNet, 2) }}</strong></td>
                <td class="text-right"><strong>₹{{ number_format($totalTax, 2) }}</strong></td>
                <td class="text-right"><strong>₹{{ number_format($totalGross, 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        Generated by Lugani Admin Panel
    </div>
</body>
</html>
