<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Shipping Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
        }

        .text-right {
            text-align: right;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 9px;
            color: #777;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Shipping Report</h1>
        <p>Generated on: {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Order No</th>
                <th>Customer</th>
                <th>Location</th>
                <th>Status</th>
                <th class="text-right">Shipping Cost</th>
            </tr>
        </thead>
        <tbody>
            @php $total = 0; @endphp
            @foreach($orders as $order)
                @php $total += $order->shipping_cost ?? 0; @endphp
                <tr>
                    <td>{{ $order->created_at->format('Y-m-d') }}</td>
                    <td>{{ $order->order_number }}</td>
                    <td>{{ $order->user ? $order->user->name : ($order->name ?: 'Guest') }}</td>
                    <td>
                        @if($order->shippingAddress)
                            {{ $order->shippingAddress->city }}, {{ $order->shippingAddress->state }}
                        @else
                            N/A
                        @endif
                    </td>
                    <td>{{ strtoupper($order->status) }}</td>
                    <td class="text-right">₹{{ number_format($order->shipping_cost ?? 0, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" class="text-right"><strong>Total Shipping Cost</strong></td>
                <td class="text-right"><strong>₹{{ number_format($total, 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        Generated by Lugani Admin Panel
    </div>
</body>

</html>