<!DOCTYPE html>
<html>

<head>
    <title>Refund Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .text-right {
            text-align: right;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2>Refund Report</h2>
        <p>Generated on {{ now()->format('M d, Y') }}</p>
        @if($request->month && $request->year)
            <p>Period: {{ date('F', mktime(0, 0, 0, $request->month, 1)) }} {{ $request->year }}</p>
        @endif
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Order #</th>
                <th>Customer</th>
                <th class="text-right">Order Amount</th>
                <th class="text-right">Deduction</th>
                <th class="text-right">Refund Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($returns as $return)
                <tr>
                    <td>{{ $return->refunded_at ? $return->refunded_at->format('M d, Y') : '-' }}</td>
                    <td>#{{ $return->order->order_number }}</td>
                    <td>{{ $return->user->name }}</td>
                    <td class="text-right">₹{{ number_format($return->order->total, 2) }}</td>
                    <td class="text-right">
                        @if($return->deduction_amount > 0)
                            ₹{{ number_format($return->deduction_amount, 2) }}
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-right">₹{{ number_format($return->refund_amount, 2) }}</td>
                </tr>
            @endforeach
            <tr style="background-color: #f9f9f9; font-weight: bold;">
                <td colspan="5" class="text-right">Total Refunded</td>
                <td class="text-right">₹{{ number_format($returns->sum('refund_amount'), 2) }}</td>
            </tr>
        </tbody>
    </table>
</body>

</html>