<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Payment Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
        }

        .text-right {
            text-align: right;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 9px;
            color: #777;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Payment Report</h1>
        <p>Generated on: {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Order No</th>
                <th>Customer</th>
                <th>Method</th>
                <th>Status</th>
                <th>Date</th>
                <th class="text-right">Net Revenue</th>
                <th class="text-right">Tax</th>
                <th class="text-right">Total Amount</th>
            </tr>
        </thead>
        <tbody>
            @php 
                                $totalRevenue = 0;
                $totalNet = 0;
                $totalTax = 0;
            @endphp
        @foreach($orders as $order)
            @php 
                                $orderTax = 0;
                if ($order->items) {
                    foreach ($order->items as $item) {
                        $storedTax = (float) $item->tax_amount;
                        if ($storedTax > 0) {
                            $orderTax += $storedTax;
                        } else {
                            $rate = $item->product ? ($item->product->tax_code ?? 18) : 18;
                            $itemTotal = $item->price * $item->quantity;
                            $taxComponent = $itemTotal * ($rate / (100 + $rate));
                            $orderTax += $taxComponent;
                        }
                    }
                }

                $orderNet = $order->total_amount - $orderTax;

                if ($order->payment_status == 'paid') {
                    $totalRevenue += $order->total_amount;
                    $totalNet += $orderNet;
                    $totalTax += $orderTax;
                }
            @endphp
                <tr>
                    <td>{{ $order->order_number }}</td>
                    <td>{{ $order->user ? $order->user->name : ($order->name ?: 'Guest') }}</td>
                    <td>{{ str_replace('_', ' ', $order->payment_method ?: 'N/A') }}</td>
                    <td>{{ strtoupper($order->payment_status) }}</td>
                    <td>{{ $order->created_at->format('Y-m-d') }}</td>
                    <td class="text-right">₹{{ number_format($orderNet, 2) }}</td>
                    <td class="text-right">₹{{ number_format($orderTax, 2) }}</td>
                    <td class="text-right">₹{{ number_format($order->total_amount, 2) }}</td>
                </tr>
        @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" class="text-right"><strong>Total (Paid Only)</strong></td>
                <td class="text-right"><strong>₹{{ number_format($totalNet, 2) }}</strong></td>
                <td class="text-right"><strong>₹{{ number_format($totalTax, 2) }}</strong></td>
                <td class="text-right"><strong>₹{{ number_format($totalRevenue, 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        Generated by Lugani Admin Panel
    </div>
</body>
</html>
