<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Reports - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Payment Analysis</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <!-- Filter Toolbar -->
                <div class="p-4 border-b border-gray-200 bg-gray-50/50">
                    <form action="{{ route('admin.reports.payments') }}" method="GET"
                        class="flex flex-wrap items-center gap-4">
                        <div class="flex items-center space-x-2">
                            <span class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Period:</span>
                            <select name="period" onchange="this.form.submit()"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5">
                                <option value="">Custom Range</option>
                                <option value="past_7_days" {{ request('period') == 'past_7_days' ? 'selected' : '' }}>
                                    Past 7 Days</option>
                                <option value="past_month" {{ request('period') == 'past_month' ? 'selected' : '' }}>Past
                                    Month</option>
                                <option value="past_year" {{ request('period') == 'past_year' ? 'selected' : '' }}>Past
                                    Year</option>
                            </select>
                        </div>

                        <div class="flex items-center space-x-2 border-l pl-4">
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                            <span class="text-gray-400">to</span>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                        </div>

                        <div class="flex items-center space-x-2 ml-auto">
                            <button type="submit"
                                class="bg-blue-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-blue-700 transition-colors">Filter</button>
                            <a href="{{ route('admin.reports.payments') }}"
                                class="bg-gray-200 text-gray-700 px-4 py-1.5 rounded-md text-xs font-bold hover:bg-gray-300 transition-colors">Reset</a>
                            <a href="{{ route('admin.reports.payments.pdf', request()->all()) }}" target="_blank"
                                class="bg-red-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-red-700 transition-colors flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                                Export PDF
                            </a>
                        </div>
                    </form>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 text-left">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Order No.</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Method</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Txn Ref</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Net Revenue</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Tax</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Total Amount</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @php 
                                $totalRevenue = 0; 
                                $totalNet = 0;
                                $totalTax = 0;
                            @endphp
                            @forelse($orders as $order)
                                @php 
                                    $orderTax = 0;
                                    // Calculate tax based on items
                                    if($order->items) {
                                        foreach($order->items as $item) {
                                            $storedTax = (float) $item->tax_amount;
                                            
                                            // Debugging: ensure we are capturing the value
                                            // dump($item->id, $storedTax); 
                                            
                                            if ($storedTax > 0) {
                                                $orderTax += $storedTax;
                                            } else {
                                                // Fallback
                                                $rate = $item->product ? ($item->product->tax_code ?? 18) : 18; 
                                                $itemTotal = $item->price * $item->quantity;
                                                $taxComponent = $itemTotal * ($rate / (100 + $rate));
                                                $orderTax += $taxComponent;
                                            }
                                        }
                                    }
                                    
                                    $orderNet = $order->total_amount - $orderTax;

                                    if ($order->payment_status == 'paid') {
                                        $totalRevenue += $order->total_amount; 
                                        $totalNet += $orderNet;
                                        $totalTax += $orderTax;
                                    }
                                @endphp
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap text-xs font-medium text-blue-600">
                                        <a href="{{ route('admin.orders.show', $order->id) }}">#{{ $order->order_number }}</a>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-900 font-medium">
                                        {{ $order->user ? $order->user->name : ($order->name ?: 'Guest') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <span class="px-2 py-0.5 inline-flex text-[10px] bg-gray-100 text-gray-700 font-semibold rounded uppercase">
                                            {{ str_replace('_', ' ', $order->payment_method ?: 'N/A') }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <span class="px-2 py-0.5 inline-flex text-[10px] font-semibold rounded-full {{ $order->payment_status == 'paid' ? 'bg-green-100 text-green-800' : 'bg-amber-100 text-amber-800' }}">
                                            {{ strtoupper($order->payment_status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-[10px] font-mono text-gray-400">
                                        {{ $order->payment_id ?: 'NO_REF' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                        {{ $order->created_at->format('M d, Y') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-xs text-gray-600">
                                        ₹{{ number_format($orderNet, 2) }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-xs text-xs text-gray-500">
                                        ₹{{ number_format($orderTax, 2) }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-xs font-bold text-gray-900">
                                        ₹{{ number_format($order->total_amount, 2) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="px-6 py-12 text-center text-gray-500 text-sm italic">
                                        No financial records found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        @if($orders->count() > 0)
                            <tfoot class="bg-gray-50">
                                <tr>
                                    <td colspan="6" class="px-6 py-4 text-xs font-bold text-gray-500 text-right uppercase tracking-wider">
                                        Totals (Paid Only)
                                    </td>
                                    <td class="px-6 py-4 text-right text-sm font-bold text-gray-700">
                                        ₹{{ number_format($totalNet, 2) }}
                                    </td>
                                    <td class="px-6 py-4 text-right text-sm font-bold text-gray-700">
                                        ₹{{ number_format($totalTax, 2) }}
                                    </td>
                                    <td class="px-6 py-4 text-right text-sm font-black text-blue-600">
                                        ₹{{ number_format($totalRevenue, 2) }}
                                    </td>
                                </tr>
                            </tfoot>
                        @endif
                    </table>
                </div>

                @if($orders->count() > 0)
                    <div class="px-6 py-4 bg-white border-t border-gray-200">
                        {{ $orders->withQueryString()->links() }}
                    </div>
                @endif
            </div>
        </main>
    </div>
</body>

</html>