<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ ucfirst($status) }} Orders Report - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">{{ ucfirst($status) }} Orders Report</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <!-- Filter Toolbar -->
                <div class="p-4 border-b border-gray-200 bg-gray-50/50">
                    <form action="{{ route('admin.reports.orders', $status) }}" method="GET" class="flex flex-wrap items-center gap-4">
                        <div class="flex items-center space-x-2">
                            <span class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Scope:</span>
                            <select name="scope" onchange="this.form.submit()" class="text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5">
                                <option value="">Global (All)</option>
                                <option value="local" {{ request('scope') == 'local' ? 'selected' : '' }}>Local Only</option>
                                <option value="national" {{ request('scope') == 'national' ? 'selected' : '' }}>National</option>
                                <option value="international" {{ request('scope') == 'international' ? 'selected' : '' }}>International</option>
                            </select>
                        </div>

                        <div class="flex items-center space-x-2 border-l pl-4">
                            <span class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Period:</span>
                            <select name="period" onchange="this.form.submit()" class="text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5">
                                <option value="">Custom Range</option>
                                <option value="past_7_days" {{ request('period') == 'past_7_days' ? 'selected' : '' }}>Past 7 Days</option>
                                <option value="past_month" {{ request('period') == 'past_month' ? 'selected' : '' }}>Past Month</option>
                                <option value="past_year" {{ request('period') == 'past_year' ? 'selected' : '' }}>Past Year</option>
                            </select>
                        </div>

                        <div class="flex items-center space-x-2 border-l pl-4">
                            <input type="date" name="start_date" value="{{ request('start_date') }}" class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                            <span class="text-gray-400">to</span>
                            <input type="date" name="end_date" value="{{ request('end_date') }}" class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                        </div>

                        <div class="flex items-center space-x-2 ml-auto">
                            <button type="submit" class="bg-blue-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-blue-700 transition-colors">Apply Filters</button>
                            <a href="{{ route('admin.reports.orders', $status) }}" class="bg-red-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-red-700 transition-colors">Reset</a>
                        </div>
                    </form>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Order</th>
                                <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Origin</th>
                                <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                                <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Payment</th>
                                <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($orders as $order)
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-3 py-4 whitespace-nowrap text-xs font-medium">
                                        <div class="text-blue-600 font-bold mb-1">#{{ $order->order_number }}</div>
                                        <span class="px-2 py-0.5 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                            {{ match ($order->getOrderScopeAttribute()) {
                                                'International' => 'bg-purple-100 text-purple-800',
                                                'National' => 'bg-orange-100 text-orange-800',
                                                'Local' => 'bg-cyan-100 text-cyan-800',
                                                default => 'bg-gray-100 text-gray-800'
                                            } }}">
                                            {{ $order->getOrderScopeAttribute() }}
                                        </span>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-500">
                                        @if($order->shippingAddress)
                                            <div class="text-gray-900 font-medium">{{ $order->shippingAddress->city }}, {{ $order->shippingAddress->state }}</div>
                                            <div class="text-[10px] text-gray-400">{{ $order->shippingAddress->country }}</div>
                                        @else
                                            <span class="text-gray-300 italic">N/A</span>
                                        @endif
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <div class="text-gray-900 font-medium">{{ $order->user ? $order->user->name : $order->name }}</div>
                                        <div class="text-[10px] text-gray-400">{{ $order->email }}</div>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-900 font-bold">
                                        ₹{{ number_format($order->total_amount, 2) }}
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <span class="px-2 py-0.5 inline-flex text-[10px] leading-4 font-semibold rounded-full {{ $order->payment_status == 'paid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ strtoupper($order->payment_status) }}
                                        </span>
                                        <div class="text-[10px] mt-1 text-gray-400 uppercase">{{ str_replace('_', ' ', $order->payment_method) }}</div>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <div>{{ $order->created_at->format('M d, Y') }}</div>
                                        <div class="text-[10px] text-gray-400">{{ $order->created_at->format('h:i A') }}</div>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-right text-xs font-medium">
                                        <a href="{{ route('admin.orders.show', $order->id) }}" class="text-blue-600 hover:text-blue-900 font-bold">View Detail</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                                        <div class="text-sm">No records matching your criteria were found.</div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($orders->count() > 0)
                    <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                        {{ $orders->withQueryString()->links() }}
                    </div>
                @endif
            </div>
        </main>
    </div>
</body>

</html>