<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Client Reports - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Client Acquisition Analysis</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <!-- Filter Toolbar -->
                <div class="p-4 border-b border-gray-200 bg-gray-50/50">
                    <form action="{{ route('admin.reports.clients') }}" method="GET"
                        class="flex flex-wrap items-center gap-4">
                        <div class="flex items-center space-x-2">
                            <span class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Join
                                Period:</span>
                            <select name="period" onchange="this.form.submit()"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5">
                                <option value="">Custom Range</option>
                                <option value="past_7_days" {{ request('period') == 'past_7_days' ? 'selected' : '' }}>
                                    Past 7 Days</option>
                                <option value="past_month" {{ request('period') == 'past_month' ? 'selected' : '' }}>Past
                                    Month</option>
                                <option value="past_year" {{ request('period') == 'past_year' ? 'selected' : '' }}>Past
                                    Year</option>
                            </select>
                        </div>

                        <div class="flex items-center space-x-2 border-l pl-4">
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                            <span class="text-gray-400">to</span>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                        </div>

                        <div class="flex items-center space-x-2 ml-auto">
                            <button type="submit"
                                class="bg-blue-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-blue-700 transition-colors">Generate
                                Report</button>
                            <a href="{{ route('admin.reports.clients') }}"
                                class="bg-red-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-red-700 transition-colors">Reset</a>
                        </div>
                    </form>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 text-left">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Client
                                    Name</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Contact
                                    Info</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Verification</th>
                                <th
                                    class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    LTV (Orders)</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Joined
                                    Date</th>
                                <th
                                    class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Status</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($clients as $client)
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-3 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div
                                                class="h-8 w-8 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-bold text-xs uppercase">
                                                {{ substr($client->name, 0, 1) }}
                                            </div>
                                            <div class="ml-3">
                                                <div class="text-xs font-bold text-gray-900">{{ $client->name }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <div class="font-medium">{{ $client->email }}</div>
                                        @if($client->whatsapp_number)
                                            <div class="text-[10px] text-green-600 font-bold">WA: {{ $client->whatsapp_number }}
                                            </div>
                                        @endif
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <span
                                            class="px-2 py-0.5 inline-flex text-[10px] font-semibold rounded-full {{ $client->email_verified_at ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ $client->email_verified_at ? 'Verified' : 'Pending' }}
                                        </span>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-center">
                                        <span
                                            class="text-xs font-bold text-gray-900 bg-gray-100 px-3 py-1 rounded-full">{{ $client->orders_count }}
                                            Orders</span>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <div>{{ $client->created_at->format('M d, Y') }}</div>
                                        <div class="text-[10px] text-gray-400">{{ $client->created_at->diffForHumans() }}
                                        </div>
                                    </td>
                                    <td class="px-3 py-4 whitespace-nowrap text-right">
                                        @if($client->is_active)
                                            <span
                                                class="text-[10px] font-bold text-green-600 uppercase tracking-widest">Active</span>
                                        @else
                                            <span
                                                class="text-[10px] font-bold text-red-600 uppercase tracking-widest">Inactive</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-12 text-center text-gray-500 text-sm">
                                        No client registrations found for this period.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($clients->count() > 0)
                    <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                        {{ $clients->withQueryString()->links() }}
                    </div>
                @endif
            </div>
        </main>
    </div>
</body>

</html>