<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Profile - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Edit Profile</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-2xl mx-auto">
                @if(session('success'))
                    <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg flex items-center">
                        <p class="text-green-700 font-medium">{{ session('success') }}</p>
                    </div>
                @endif

                @if($errors->any())
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
                        <ul class="list-disc list-inside text-sm text-red-700">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="bg-white rounded-xl shadow-lg p-8">
                    <form action="{{ route('admin.profile.update') }}" method="POST" class="space-y-6">
                        @csrf

                        <!-- Name -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                            <input type="text" name="name" value="{{ old('name', auth()->user()->name) }}" required
                                class="block w-full rounded-lg border-gray-300 border focus:ring-blue-500 focus:border-blue-500 py-3 px-4">
                        </div>

                        <!-- Email -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                            <input type="email" name="email" value="{{ old('email', auth()->user()->email) }}" required
                                class="block w-full rounded-lg border-gray-300 border focus:ring-blue-500 focus:border-blue-500 py-3 px-4">
                        </div>

                        <!-- WhatsApp Number -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">WhatsApp / Contact Number (Used
                                for Reseller Support)</label>
                            <div class="relative">
                                <span
                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-500">
                                    +91
                                </span>
                                <input type="text" name="whatsapp_number"
                                    value="{{ old('whatsapp_number', auth()->user()->whatsapp_number) }}"
                                    class="pl-12 block w-full rounded-lg border-gray-300 border focus:ring-blue-500 focus:border-blue-500 py-3 px-4"
                                    placeholder="9876543210 (Optional)">
                            </div>
                            <p class="text-xs text-gray-500 mt-1">This number will be displayed to Resellers for
                                support.</p>
                        </div>

                        <div class="pt-4 flex justify-between items-center">
                            <a href="{{ route('admin.profile.change-password') }}"
                                class="text-sm text-blue-600 hover:text-blue-800">Change Password?</a>
                            <button type="submit"
                                class="flex justify-center py-3 px-6 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-200">
                                Update Profile
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>