<!DOCTYPE html>
<html>

<head>
    <title>Products List</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
        }

        .variations-table {
            width: 100%;
            border: none;
            margin-top: 5px;
        }

        .variations-table td {
            border: none;
            border-bottom: 1px solid #eee;
            padding: 4px 0;
            font-size: 9px;
        }

        .variations-table tr:last-child td {
            border-bottom: none;
        }
    </style>
</head>

<body>
    <h2>Products List</h2>
    <table>
        <thead>
            <tr>
                <th style="width: 5%;">ID</th>
                <th style="width: 20%;">Name</th>
                <th style="width: 10%;">Category</th>
                <th style="width: 10%;">Base Price</th>
                <th style="width: 55%;">Variations (Attributes | MRP | SP | Stock | SKU)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($products as $product)
                <tr>
                    <td>{{ $product->id }}</td>
                    <td>
                        {{ $product->name }}<br>
                        <small style="color: #666;">Slug: {{ $product->slug }}</small>
                    </td>
                    <td>{{ $product->category ? $product->category->name : 'N/A' }}</td>
                    <td>
                        MRP: {{ $product->mrp }}<br>
                        SP: {{ $product->sp }}
                    </td>
                    <td>
                        @if($product->variations->count() > 0)
                            <table class="variations-table">
                                @foreach($product->variations as $variation)
                                    <tr>
                                        <td style="width: 40%">
                                            @foreach($variation->options as $option)
                                                <b>{{ $option->attribute_name }}:</b> {{ $option->attribute_value }}
                                                @if(!$loop->last) | @endif
                                            @endforeach
                                        </td>
                                        <td style="width: 15%">MRP: {{ $variation->mrp }}</td>
                                        <td style="width: 15%">SP: {{ $variation->sp }}</td>
                                        <td style="width: 15%">Stock: {{ $variation->stock }}</td>
                                        <td style="width: 15%">SKU: {{ $variation->sku ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </table>
                        @else
                            No variations
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>