<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Product - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        [x-cloak] {
            display: none !important;
        }
    </style>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <h2 class="text-2xl font-semibold text-gray-800">Add Product</h2>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">

            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg flex items-center">
                    <svg class="h-5 w-5 text-green-400 mr-3" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                            clip-rule="evenodd" />
                    </svg>
                    <p class="text-sm text-green-700">{{ session('success') }}</p>
                </div>
            @endif

            @if ($errors->any())
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
                    <ul class="list-disc list-inside text-sm text-red-700">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.products.store') }}" method="POST" enctype="multipart/form-data"
                @submit.prevent="if(validateAll()) $el.submit()" x-data="{ 
                      activeTab: 'general',
                      tabs: ['general', 'description', 'additional', 'seo', 'linked', 'variations'],
                      validateAndNext(currentTab) {
                        const container = document.getElementById('tab-' + currentTab);
                        if (!container) return;
                        const inputs = container.querySelectorAll('input, select, textarea');
                        let isValid = true;
                        
                        // Check all inputs
                        for (const input of inputs) {
                            if (!input.checkValidity()) {
                                // Check if input is hidden (common with CKEditor or other plugins)
                                if (input.offsetParent === null || (input.style.display === 'none')) {
                                     // Basic fallback notification
                                     const label = input.getAttribute('name') ? input.getAttribute('name').replace(/_/g, ' ') : 'field';
                                     // You might want to use a toast here instead of alert in production, but alert ensures visibility
                                     alert(`Please fill out the ${label} field.`);
                                } else {
                                    input.reportValidity();
                                }
                                isValid = false;
                                return; // Stop and show the first error
                            }
                        }
                        
                        if (isValid) {
                            const idx = this.tabs.indexOf(currentTab);
                            if (idx !== -1 && idx < this.tabs.length - 1) {
                                this.activeTab = this.tabs[idx + 1];
                                window.scrollTo({ top: 0, behavior: 'smooth' });
                            }
                        }
                      },
                      
                      validateAll() {
                          for (const tab of this.tabs) {
                              const container = document.getElementById('tab-' + tab);
                              if (!container) continue;
                              const inputs = container.querySelectorAll('input, select, textarea');
                              
                              for (const input of inputs) {
                                  if (!input.checkValidity()) {
                                      this.activeTab = tab;
                                      setTimeout(() => {
                                          if (input.offsetParent === null || (input.style.display === 'none')) {
                                                 const label = input.getAttribute('name') ? input.getAttribute('name').replace(/_/g, ' ') : 'field';
                                                 alert(`Please fill out the ${label} field.`);
                                          } else {
                                              input.reportValidity();
                                              input.focus();
                                          }
                                      }, 150);
                                      return false;
                                  }
                              }
                          }
                          return true;
                      },

                      subcategories: [],
                      attributes: [], // Stores defined attributes like ['Size', 'Color']
                      newAttribute: '',
                      isReturnable: true, // Default to true
                      variations: [], // Stores rows like [{ attributes: {'Size': 'M'}, mrp: 100, ... }]
                      upsellProducts: [],
                      crossSellProducts: [],
                      
                      sp: '',
                      taxCode: '{{ isset($defaultTaxRate) ? \App\Models\TaxRate::find($defaultTaxRate)->rate : "18" }}',
                      get basePrice() {
                          if(!this.sp) return 0;
                          const sp = parseFloat(this.sp);
                          const rate = parseFloat(this.taxCode);
                          return (sp * (100 / (100 + rate))).toFixed(2);
                      },
                      get taxAmount() {
                          if(!this.sp) return 0;
                          const sp = parseFloat(this.sp);
                          return (sp - this.basePrice).toFixed(2);
                      },

                      async searchProducts(query) {
                          if (query.length < 2) return [];
                          const res = await fetch(`/admin/products/search-suggestions?query=${query}`);
                          return await res.json();
                      },
                      
                      addAttribute() {
                        if (this.newAttribute.trim() !== '' && !this.attributes.includes(this.newAttribute.trim())) {
                            this.attributes.push(this.newAttribute.trim());
                            this.newAttribute = '';
                            // Initialize new attribute in existing variations
                            this.variations.forEach(v => v.attributes[this.attributes[this.attributes.length - 1]] = '');
                        }
                      },
                      
                      removeAttribute(index) {
                         const removedAttr = this.attributes[index];
                         this.attributes.splice(index, 1);
                         // Remove from variations
                         this.variations.forEach(v => delete v.attributes[removedAttr]);
                      },

                      previewImages: [],
                      selectedFiles: [],
                      
                      handleFileUpload(event) {
                        const files = event.target.files;
                        this.selectedFiles = Array.from(files);
                        this.updatePreviews();
                      },

                      updatePreviews() {
                          this.previewImages = this.selectedFiles.map(file => ({
                              name: file.name,
                              url: URL.createObjectURL(file)
                          }));
                      },

                      removeImage(index) {
                          this.selectedFiles.splice(index, 1);
                          this.updateFilesInInput();
                          this.updatePreviews();
                      },

                      setAsDefault(index) {
                          if (index === 0) return;
                          const file = this.selectedFiles.splice(index, 1)[0];
                          this.selectedFiles.unshift(file);
                          this.updateFilesInInput();
                          this.updatePreviews();
                      },

                      updateFilesInInput() {
                          const dt = new DataTransfer();
                          this.selectedFiles.forEach(file => dt.items.add(file));
                          document.getElementById('dropzone-file').files = dt.files;
                      },

                      addVariation() {
                          let newVar = {
                              id: Date.now(),
                              mrp: '',
                              sp: '',
                              reseller_price: '',
                              stock: 100,
                              sku: '',
                              attributes: {}
                          };
                          // Pre-fill attributes empty
                          this.attributes.forEach(attr => newVar.attributes[attr] = '');
                          this.variations.push(newVar);
                      },

                      removeVariation(index) {
                          this.variations.splice(index, 1);
                      }
                  }">
                @csrf

                <div class="bg-white rounded-xl shadow-sm overflow-hidden">
                    <div class="border-b border-gray-200">
                        <nav class="-mb-px flex">
                            <button type="button" @click="activeTab = 'general'"
                                :class="{'border-blue-500 text-blue-600': activeTab === 'general', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'general'}"
                                class="flex-1 py-4 px-1 text-center border-b-2 font-medium text-sm">
                                General Info
                            </button>
                            <button type="button" @click="activeTab = 'description'"
                                :class="{'border-blue-500 text-blue-600': activeTab === 'description', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'description'}"
                                class="flex-1 py-4 px-1 text-center border-b-2 font-medium text-sm">
                                Description & Images
                            </button>
                            <button type="button" @click="activeTab = 'additional'"
                                :class="{'border-blue-500 text-blue-600': activeTab === 'additional', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'additional'}"
                                class="flex-1 py-4 px-1 text-center border-b-2 font-medium text-sm">
                                Additional Info
                            </button>
                            <button type="button" @click="activeTab = 'seo'"
                                :class="{'border-blue-500 text-blue-600': activeTab === 'seo', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'seo'}"
                                class="flex-1 py-4 px-1 text-center border-b-2 font-medium text-sm">
                                SEO
                            </button>
                            <button type="button" @click="activeTab = 'linked'"
                                :class="{'border-blue-500 text-blue-600': activeTab === 'linked', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'linked'}"
                                class="flex-1 py-4 px-1 text-center border-b-2 font-medium text-sm">
                                Linked Products
                            </button>
                            <button type="button" @click="activeTab = 'variations'"
                                :class="{'border-blue-500 text-blue-600': activeTab === 'variations', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'variations'}"
                                class="flex-1 py-4 px-1 text-center border-b-2 font-medium text-sm">
                                Variations
                            </button>
                        </nav>
                    </div>

                    <div class="p-6">
                        <!-- General Info Tab -->
                        <div id="tab-general" x-show="activeTab === 'general'" x-cloak class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Category *</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z" />
                                            </svg>
                                        </div>
                                        <select name="category_id" id="category_id" required
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 appearance-none"
                                            @change="fetch(`/admin/categories/${$event.target.value}/subcategories`).then(res => res.json()).then(data => subcategories = data)">
                                            <option value="">Select Category</option>
                                            @foreach($categories as $cat)
                                                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Subcategory
                                        (Optional)</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 19a2 2 0 01-2-2V7a2 2 0 012-2h4l2 2h4a2 2 0 012 2v1M5 19h14a2 2 0 002-2v-5a2 2 0 00-2-2H9a2 2 0 00-2 2v5a2 2 0 01-2 2z" />
                                            </svg>
                                        </div>
                                        <select name="subcategory_id"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 appearance-none">
                                            <option value="">Select Subcategory</option>
                                            <template x-for="sub in subcategories" :key="sub.id">
                                                <option :value="sub.id" x-text="sub.name"></option>
                                            </template>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Product Name *</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                        </svg>
                                    </div>
                                    <input type="text" name="name" required
                                        class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                </div>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">URL Slug (Optional)</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1" />
                                        </svg>
                                    </div>
                                    <input type="text" name="slug"
                                        class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">MRP *</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 font-bold">₹</span>
                                        </div>
                                        <input type="number" step="0.01" name="mrp" required
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Selling Price (SP)
                                        *</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 font-bold">₹</span>
                                        </div>
                                        <input type="number" step="0.01" name="sp" x-model="sp" required
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Number of Units
                                        *</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                            </svg>
                                        </div>
                                        <input type="number" name="number_of_units" required min="1" value="1"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                    </div>
                                    <p class="text-xs text-gray-500 mt-1">Default is 1 unit.</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Unit Type</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                                            </svg>
                                        </div>
                                        <input type="text" name="unit_type" list="unit_types"
                                            placeholder="e.g. pc, kg, ltr"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                        <datalist id="unit_types">
                                            <option value="pc">
                                            <option value="kg">
                                            <option value="gm">
                                            <option value="ltr">
                                            <option value="ml">
                                            <option value="meter">
                                            <option value="box">
                                            <option value="pack">
                                        </datalist>
                                    </div>
                                    <p class="text-xs text-gray-500 mt-1">Select or type a unit (e.g., pc, kg).</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Reseller Price
                                        (Optional)</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 font-bold">₹</span>
                                        </div>
                                        <input type="number" step="0.01" name="reseller_price"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                    </div>
                                    <p class="text-xs text-gray-500 mt-1">Defaults to SP if left empty. <strong
                                            class="text-red-600">Note:
                                            This price is for wholesellers.</strong></p>
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Tax Code (%)</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M7 20l4-16m2 16l4-16M6 9h14M4 15h14" />
                                            </svg>
                                        </div>
                                        <select name="tax_code" x-model="taxCode"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 appearance-none">
                                            <option value="0">0%</option>
                                            @foreach(\App\Models\TaxRate::where('is_active', true)->get() as $rate)
                                                <option value="{{ $rate->rate }}">{{ $rate->name }} ({{ $rate->rate }}%)
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="mt-2 text-xs text-gray-600 bg-blue-50 p-2 rounded border border-blue-100"
                                        x-show="sp">
                                        <span class="font-semibold">Breakdown:</span>
                                        Base Price: ₹<span x-text="basePrice"></span> +
                                        Tax: ₹<span x-text="taxAmount"></span>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">HSN Code
                                        (Optional)</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
                                            </svg>
                                        </div>
                                        <input type="text" name="hsn_code"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                    </div>
                                </div>
                            </div>
                            <div class="flex justify-end mt-4">
                                <button type="button" @click="validateAndNext('general')"
                                    class="px-6 py-2.5 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition duration-200">Next:
                                    Description & Images</button>
                            </div>
                        </div>

                        <!-- Description & Images Tab -->
                        <div id="tab-description" x-show="activeTab === 'description'" x-cloak class="space-y-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Product Images
                                    (Optional)</label>
                                <div class="flex items-center justify-center w-full">
                                    <label for="dropzone-file"
                                        class="flex flex-col items-center justify-center w-full h-32 border-2 border-gray-300 border-dashed rounded-lg cursor-pointer bg-gray-50 hover:bg-gray-100">
                                        <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                            <svg class="w-8 h-8 mb-4 text-gray-500" aria-hidden="true"
                                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 16">
                                                <path stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" stroke-width="2"
                                                    d="M13 13h3a3 3 0 0 0 0-6h-.025A5.56 5.56 0 0 0 16 6.5 5.5 5.5 0 0 0 5.207 5.021C5.137 5.017 5.071 5 5 5a4 4 0 0 0 0 8h2.167M10 15V6m0 0L8 8m2-2 2 2" />
                                            </svg>
                                            <p class="mb-2 text-sm text-gray-500"><span class="font-semibold">Click to
                                                    upload</span> or drag and drop</p>
                                            <p class="text-xs text-gray-500">SVG, PNG, JPG or GIF (MAX. 5MB)</p>
                                        </div>
                                        <input id="dropzone-file" name="images[]" type="file" multiple class="hidden"
                                            @change="handleFileUpload" />
                                    </label>
                                </div>
                                <div class="mt-4 grid grid-cols-2 md:grid-cols-4 gap-4"
                                    x-show="previewImages.length > 0" x-cloak>
                                    <template x-for="(img, index) in previewImages" :key="index">
                                        <div class="relative group border rounded-lg overflow-hidden h-24 bg-gray-100">
                                            <img :src="img.url" class="h-full w-full object-cover" :alt="img.name">

                                            <!-- Default Button -->
                                            <button type="button" @click="setAsDefault(index)"
                                                class="absolute top-1 left-1 rounded-full p-1 shadow-sm transition-opacity"
                                                :class="index === 0 ? 'bg-yellow-400 text-white opacity-100' : 'bg-white text-gray-400 opacity-0 group-hover:opacity-100 hover:text-yellow-400'"
                                                :title="index === 0 ? 'First Image (Default)' : 'Move to First'">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3"
                                                    viewBox="0 0 20 20" fill="currentColor">
                                                    <path
                                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                </svg>
                                            </button>

                                            <!-- Remove Button -->
                                            <button type="button" @click="removeImage(index)"
                                                class="absolute top-1 right-1 bg-red-500 text-white rounded-full p-1 shadow-sm opacity-0 group-hover:opacity-100 transition-opacity">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                </svg>
                                            </button>
                                        </div>
                                    </template>
                                </div>
                                <p class="text-xs text-gray-500 mt-2">Alt tags will default to product name.</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Short Description *</label>
                                <textarea name="short_description" id="short_description"
                                    required>{{ old('short_description') }}</textarea>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Long Description
                                    (Optional)</label>
                                <textarea name="long_description"
                                    id="long_description">{{ old('long_description') }}</textarea>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Dispatch Days *</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path
                                                    d="M9 17a2 2 0 11-4 0 2 2 0 014 0zM19 17a2 2 0 11-4 0 2 2 0 014 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 104 0m-4 0a2 2 0 114 0m6 0a2 2 0 104 0m-4 0a2 2 0 114 0" />
                                            </svg>
                                        </div>
                                        <input type="number" name="dispatch_days" required min="0"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Country/Region</label>
                                    <div class="relative">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <select name="country_origin"
                                            class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 appearance-none">
                                            <option value="India" selected>India</option>
                                            <option value="China">China</option>
                                            <option value="USA">USA</option>
                                            <option value="UK">UK</option>
                                            <!-- Add more countries as needed -->
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="flex justify-end mt-4">
                                <button type="button" @click="validateAndNext('description')"
                                    class="px-6 py-2.5 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition duration-200">Next:
                                    Additional Info</button>
                            </div>
                        </div>

                        <!-- Additional Info Tab -->
                        <div id="tab-additional" x-show="activeTab === 'additional'" x-cloak class="space-y-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Warranty Details
                                    (Optional)</label>
                                <div class="relative">
                                    <div class="absolute top-3 left-3 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                    </div>
                                    <textarea name="warranty_details" rows="3"
                                        class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500"></textarea>
                                </div>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Guarantee Details
                                    (Optional)</label>
                                <div class="relative">
                                    <div class="absolute top-3 left-3 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                        </svg>
                                    </div>
                                    <textarea name="guarantee_details" rows="3"
                                        class="block w-full pl-10 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500"></textarea>
                                </div>
                            </div>


                            <div class="border-t border-gray-200 pt-6 mt-6">
                                <h3 class="text-lg font-medium text-gray-900 mb-4">Return Policy</h3>
                                <div class="space-y-4">
                                    <div class="flex items-start">
                                        <div class="flex items-center h-5">
                                            <input id="is_returnable" name="is_returnable" type="checkbox"
                                                x-model="isReturnable"
                                                class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300 rounded">
                                        </div>
                                        <div class="ml-3 text-sm">
                                            <label for="is_returnable" class="font-medium text-gray-700">This product is
                                                returnable</label>
                                            <p class="text-gray-500">Enable if customers can return this product after
                                                delivery.</p>
                                        </div>
                                    </div>

                                    <div x-show="isReturnable" x-transition
                                        class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Return Window
                                                (Days)</label>
                                            <input type="number" name="return_window_days" min="0"
                                                value="{{ \App\Models\GeneralSetting::value('return_window_days') ?? 7 }}"
                                                class="block w-full pl-3 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                                            <p class="text-xs text-gray-500 mt-1">Leave empty to use global default.</p>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Return Policy
                                                Description (Optional)</label>
                                            <textarea name="return_policy_desc" rows="3"
                                                class="block w-full pl-3 pr-3 py-3 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500"
                                                placeholder="Specific return conditions for this product..."></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="flex justify-end mt-4">
                                <button type="button" @click="validateAndNext('additional')"
                                    class="px-6 py-2.5 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition duration-200">Next:
                                    SEO</button>
                            </div>
                        </div>
                    </div>

                    <!-- SEO Tab -->
                    <div id="tab-seo" x-show="activeTab === 'seo'" x-cloak class="p-6 space-y-6" x-data="{ 
                            metaTitle: '', 
                            metaDesc: '',
                            getWordCount(text) {
                                return text.trim().split(/\s+/).filter(word => word.length > 0).length;
                            },
                            getColorClass(current, max) {
                                const percentage = (current / max) * 100;
                                if (percentage > 100) return 'bg-red-500';
                                if (percentage > 80) return 'bg-yellow-500';
                                return 'bg-green-500';
                            },
                            getTextColorClass(current, max) {
                                const percentage = (current / max) * 100;
                                if (percentage > 100) return 'text-red-600';
                                if (percentage > 80) return 'text-yellow-600';
                                return 'text-green-600';
                            }
                        }">

                        <!-- Schema Markup -->
                        <div>
                            <label for="schema_markup" class="block text-sm font-medium text-gray-700 mb-2">Schema
                                Markup (JSON-LD)</label>
                            <textarea name="schema_markup" id="schema_markup" rows="3"
                                class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm font-mono text-xs"
                                placeholder='<script type="application/ld+json">{ ... }</script>'>{{ old('schema_markup') }}</textarea>
                            <p class="mt-1 text-xs text-gray-500">Paste your custom Schema.org JSON-LD code here.</p>
                        </div>

                        <div class="border-t pt-6 mt-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">SEO Settings</h3>

                            <!-- Meta Title -->
                            <div class="mb-4">
                                <div class="flex justify-between items-end mb-1">
                                    <label for="meta_title" class="block text-sm font-medium text-gray-700">Meta
                                        Title</label>
                                    <div class="text-xs text-gray-500 flex gap-2">
                                        <span><span x-text="getWordCount(metaTitle)">0</span> words</span>
                                        <span>|</span>
                                        <span :class="getTextColorClass(metaTitle.length, 60)">
                                            <span x-text="metaTitle.length">0</span>/60 chars
                                        </span>
                                    </div>
                                </div>
                                <input type="text" name="meta_title" id="meta_title" x-model="metaTitle"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm mb-1">
                                <!-- Progress Bar -->
                                <div class="w-full bg-gray-200 rounded-full h-1.5 dark:bg-gray-700">
                                    <div class="h-1.5 rounded-full transition-all duration-300"
                                        :class="getColorClass(metaTitle.length, 60)"
                                        :style="`width: ${Math.min((metaTitle.length / 60) * 100, 100)}%`"></div>
                                </div>
                            </div>

                            <!-- Meta Description -->
                            <div class="mb-4">
                                <div class="flex justify-between items-end mb-1">
                                    <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta
                                        Description</label>
                                    <div class="text-xs text-gray-500 flex gap-2">
                                        <span><span x-text="getWordCount(metaDesc)">0</span> words</span>
                                        <span>|</span>
                                        <span :class="getTextColorClass(metaDesc.length, 160)">
                                            <span x-text="metaDesc.length">0</span>/160 chars
                                        </span>
                                    </div>
                                </div>
                                <textarea name="meta_description" id="meta_description" rows="3" x-model="metaDesc"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm mb-1"></textarea>
                                <!-- Progress Bar -->
                                <div class="w-full bg-gray-200 rounded-full h-1.5 dark:bg-gray-700">
                                    <div class="h-1.5 rounded-full transition-all duration-300"
                                        :class="getColorClass(metaDesc.length, 160)"
                                        :style="`width: ${Math.min((metaDesc.length / 160) * 100, 100)}%`"></div>
                                </div>
                            </div>

                            <!-- Meta Keywords -->
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Meta Keywords</label>
                                <textarea name="meta_keywords" rows="3"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm"
                                    placeholder="comma, separated, keywords"></textarea>
                            </div>

                            <!-- Breadcrumbs Title -->
                            <div class="mb-4">
                                <label for="breadcrumbs_title"
                                    class="block text-sm font-medium text-gray-700 mb-2">Breadcrumbs Title</label>
                                <input type="text" name="breadcrumbs_title" id="breadcrumbs_title"
                                    value="{{ old('breadcrumbs_title') }}"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm"
                                    placeholder="Short title for breadcrumbs">
                            </div>

                            <!-- Canonical URL -->
                            <div class="mb-4">
                                <label for="canonical_url"
                                    class="block text-sm font-medium text-gray-700 mb-2">Canonical URL</label>
                                <input type="url" name="canonical_url" id="canonical_url"
                                    value="{{ old('canonical_url') }}"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm"
                                    placeholder="https://example.com/canonical-url">
                            </div>
                        </div>

                        <div class="flex justify-end mt-4">
                            <button type="button" @click="validateAndNext('seo')"
                                class="px-6 py-2.5 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition duration-200">Next:
                                Linked Products</button>
                        </div>
                    </div>

                    <!-- Linked Products Tab -->
                    <div id="tab-linked" x-show="activeTab === 'linked'" x-cloak class="p-6 space-y-6">

                        <!-- Upsells -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-200"
                            x-data="{ query: '', results: [], async search() { if(this.query.length < 2) {this.results=[]; return;} this.results = await searchProducts(this.query) } }">
                            <h3 class="text-sm font-medium text-gray-900 mb-3">Upsell Products</h3>
                            <p class="text-xs text-gray-500 mb-2">Products that you want to recommend as an upgrade or
                                premium alternative.</p>

                            <div class="relative mb-4">
                                <input type="text" x-model="query" @input.debounce.300ms="search()"
                                    placeholder="Search products..."
                                    class="block w-full text-sm border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500">
                                <div x-show="results.length > 0 && query.length >= 2" @click.outside="results = []"
                                    class="absolute z-10 w-full bg-white shadow-lg max-h-60 rounded-md py-1 text-base overflow-auto sm:text-sm border border-gray-200 mt-1">
                                    <template x-for="product in results" :key="product.id">
                                        <div @click="if(!upsellProducts.find(p => p.id === product.id)) upsellProducts.push(product); query = ''; results = [];"
                                            class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-gray-100">
                                            <span x-text="product.name" class="font-medium block truncate"></span>
                                        </div>
                                    </template>
                                </div>
                            </div>

                            <div class="space-y-2">
                                <template x-for="(product, index) in upsellProducts" :key="product.id">
                                    <div
                                        class="flex items-center justify-between bg-white p-2 rounded border border-gray-200">
                                        <span x-text="product.name" class="text-sm text-gray-700"></span>
                                        <button type="button" @click="upsellProducts.splice(index, 1)"
                                            class="text-red-500 hover:text-red-700">
                                            <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                        </button>
                                        <!-- Hidden Input -->
                                        <input type="hidden" name="upsell_products[]" :value="product.id">
                                    </div>
                                </template>
                                <template x-if="upsellProducts.length === 0">
                                    <div class="text-sm text-gray-400 italic">No upsell products selected.</div>
                                </template>
                            </div>
                        </div>

                        <!-- Cross-sells -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-200"
                            x-data="{ query: '', results: [], async search() { if(this.query.length < 2) {this.results=[]; return;} this.results = await searchProducts(this.query) } }">
                            <h3 class="text-sm font-medium text-gray-900 mb-3">Cross-sell Products</h3>
                            <p class="text-xs text-gray-500 mb-2">Products that you want to recommend as complementary
                                items (e.g. accessories).</p>

                            <div class="relative mb-4">
                                <input type="text" x-model="query" @input.debounce.300ms="search()"
                                    placeholder="Search products..."
                                    class="block w-full text-sm border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500">
                                <div x-show="results.length > 0 && query.length >= 2" @click.outside="results = []"
                                    class="absolute z-10 w-full bg-white shadow-lg max-h-60 rounded-md py-1 text-base overflow-auto sm:text-sm border border-gray-200 mt-1">
                                    <template x-for="product in results" :key="product.id">
                                        <div @click="if(!crossSellProducts.find(p => p.id === product.id)) crossSellProducts.push(product); query = ''; results = [];"
                                            class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-gray-100">
                                            <span x-text="product.name" class="font-medium block truncate"></span>
                                        </div>
                                    </template>
                                </div>
                            </div>

                            <div class="space-y-2">
                                <template x-for="(product, index) in crossSellProducts" :key="product.id">
                                    <div
                                        class="flex items-center justify-between bg-white p-2 rounded border border-gray-200">
                                        <span x-text="product.name" class="text-sm text-gray-700"></span>
                                        <button type="button" @click="crossSellProducts.splice(index, 1)"
                                            class="text-red-500 hover:text-red-700">
                                            <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                        </button>
                                        <input type="hidden" name="cross_sell_products[]" :value="product.id">
                                    </div>
                                </template>
                                <template x-if="crossSellProducts.length === 0">
                                    <div class="text-sm text-gray-400 italic">No cross-sell products selected.</div>
                                </template>
                            </div>
                        </div>
                        <div class="flex justify-end mt-4">
                            <button type="button" @click="validateAndNext('linked')"
                                class="px-6 py-2.5 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition duration-200">Next:
                                Variations</button>
                        </div>
                    </div>

                    <!-- Variations Tab -->
                    <div id="tab-variations" x-show="activeTab === 'variations'" x-cloak class="p-6 space-y-6">

                        <!-- Attribute Configuration -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                            <h3 class="text-sm font-medium text-gray-900 mb-3">1. Define Attributes</h3>
                            <div class="flex gap-2 mb-2">
                                <input type="text" x-model="newAttribute" @keyup.enter="addAttribute"
                                    placeholder="e.g. Size, Color, Weight"
                                    class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-2 border">
                                <button type="button" @click="addAttribute"
                                    class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Add Attribute
                                </button>
                            </div>
                            <div class="flex flex-wrap gap-2 mt-2">
                                <template x-for="(attr, index) in attributes" :key="index">
                                    <span
                                        class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        <span x-text="attr"></span>
                                        <button type="button" @click="removeAttribute(index)"
                                            class="flex-shrink-0 ml-1.5 h-4 w-4 rounded-full inline-flex items-center justify-center text-blue-600 hover:bg-blue-200 hover:text-blue-500 focus:outline-none focus:bg-blue-500 focus:text-white">
                                            <span class="sr-only">Remove attribute</span>
                                            <svg class="h-2 w-2" stroke="currentColor" fill="none" viewBox="0 0 8 8">
                                                <path stroke-linecap="round" stroke-width="1.5" d="M1 1l6 6m0-6L1 7" />
                                            </svg>
                                        </button>
                                    </span>
                                </template>
                            </div>
                            <p class="text-xs text-gray-500 mt-2">Add attributes that vary between products (e.g.,
                                Size, Color).</p>
                        </div>

                        <!-- Variations List -->
                        <div>
                            <div class="flex justify-between items-center mb-4">
                                <h3 class="text-sm font-medium text-gray-900">2. Product Variations</h3>
                                <button type="button" @click="addVariation"
                                    class="inline-flex items-center px-3 py-2 border border-blue-600 text-sm leading-4 font-medium rounded-md text-blue-600 bg-white hover:bg-blue-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    + Add Variation
                                </button>
                            </div>

                            <div class="space-y-4">
                                <template x-for="(variation, index) in variations" :key="variation.id">
                                    <div class="border border-gray-200 rounded-lg p-4 bg-white shadow-sm relative">
                                        <button type="button" @click="removeVariation(index)"
                                            class="absolute top-2 right-2 text-red-500 hover:text-red-700">
                                            <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                        </button>

                                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                            <!-- Dynamic Attributes -->
                                            <template x-for="attr in attributes" :key="attr">
                                                <div>
                                                    <label class="block text-sm font-medium text-gray-700 mb-1"
                                                        x-text="attr"></label>
                                                    <!-- Name convention: variations[index][attributes][Name] -->
                                                    <input type="text"
                                                        :name="`variations[${index}][attributes][${attr}]`"
                                                        x-model="variation.attributes[attr]" required
                                                        class="block w-full border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm py-2 px-3">
                                                </div>
                                            </template>

                                            <!-- Standard Fields -->
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-1">MRP</label>
                                                <input type="number" :name="`variations[${index}][mrp]`"
                                                    x-model="variation.mrp" step="0.01" required
                                                    class="block w-full border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm py-2 px-3">
                                            </div>
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-1">SP</label>
                                                <input type="number" :name="`variations[${index}][sp]`"
                                                    x-model="variation.sp" step="0.01" required
                                                    class="block w-full border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm py-2 px-3">
                                                <div class="mt-1 text-[10px] text-gray-500" x-show="variation.sp">
                                                    Base: ₹<span
                                                        x-text="(parseFloat(variation.sp || 0) * (100 / (100 + parseFloat(taxCode || 0)))).toFixed(2)"></span>
                                                    + Tax: ₹<span
                                                        x-text="(parseFloat(variation.sp || 0) - (parseFloat(variation.sp || 0) * (100 / (100 + parseFloat(taxCode || 0))))).toFixed(2)"></span>
                                                </div>
                                            </div>
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-1">Reseller
                                                    Price</label>
                                                <input type="number" :name="`variations[${index}][reseller_price]`"
                                                    x-model="variation.reseller_price" step="0.01"
                                                    class="block w-full border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm py-2 px-3">
                                            </div>
                                            <div>
                                                <label
                                                    class="block text-sm font-medium text-gray-700 mb-1">Stock</label>
                                                <input type="number" :name="`variations[${index}][stock]`"
                                                    x-model="variation.stock" required
                                                    class="block w-full border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm py-2 px-3">
                                            </div>
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-1">SKU</label>
                                                <input type="text" :name="`variations[${index}][sku]`"
                                                    x-model="variation.sku"
                                                    class="block w-full border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm py-2 px-3">
                                            </div>
                                            <!-- Image Upload -->
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-1">Image
                                                    (Optional)</label>
                                                <input type="file" :name="`variations[${index}][image]`"
                                                    accept="image/*"
                                                    class="block w-full text-sm text-gray-500 file:mr-2 file:py-2 file:px-3 file:rounded-full file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                            </div>
                                        </div>
                                    </div>
                                </template>
                                <template x-if="variations.length === 0">
                                    <div class="text-center py-4 text-gray-500 text-sm italic">
                                        No variations added yet. Define attributes and add a variation.
                                    </div>
                                </template>
                            </div>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="mt-8 pt-6 border-t border-gray-200 p-6" x-show="activeTab === 'variations'">
                        <button type="submit"
                            class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-200">
                            Create Product
                        </button>
                    </div>
                </div>
    </div>
    </form>
    </main>
    </div>
    <script src="https://cdn.ckeditor.com/ckeditor5/35.1.0/classic/ckeditor.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Helper to init CKEditor and sync data
            const initEditor = (selector) => {
                const element = document.querySelector(selector);
                if (element) {
                    ClassicEditor
                        .create(element)
                        .then(editor => {
                            // Sync data on change
                            editor.model.document.on('change:data', () => {
                                element.value = editor.getData();
                                // Dispatch input event to ensure any listeners catch it
                                element.dispatchEvent(new Event('input'));
                            });
                        })
                        .catch(error => {
                            console.error(error);
                        });
                }
            };

            initEditor('#short_description');
            initEditor('#long_description');
        });
    </script>
</body>

</html>