@php
    $generalSettings = \App\Models\GeneralSetting::first();
    $fontFamilyConfig = $generalSettings?->admin_font_family ?? "'Inter', sans-serif";
    $fontSize = $generalSettings?->admin_font_size;

    // Check if it's a simple font name or a complex string
    $isCustomGoogleFont = !str_contains($fontFamilyConfig, ',');
    $importFont = $isCustomGoogleFont ? $fontFamilyConfig : null;
    $fontFamilyValue = $isCustomGoogleFont ? "'$fontFamilyConfig', sans-serif" : $fontFamilyConfig;
@endphp

@if($importFont)
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family={{ str_replace(' ', '+', $importFont) }}:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
@endif

<style>
    html {
        @if($fontSize)
            font-size:
                {{ $fontSize }}
                !important;
        @endif
    }

    body {
        font-family:
            {!! $fontFamilyValue !!}
            !important;
    }
</style>