@php
    $currentRoute = Route::currentRouteName();

    // Helper function to check if a route is active (recursive for groups)
    $isActive = function ($routes) use ($currentRoute) {
        if (is_array($routes)) {
            foreach ($routes as $route) {
                if (Str::startsWith($currentRoute, $route)) {
                    return true;
                }
            }
            return false;
        }
        return Str::startsWith($currentRoute, $routes);
    };

    $isCatalogActive = $isActive(['admin.categories', 'admin.products', 'admin.orders', 'admin.tickets', 'admin.returns']);
    $isMarketingActive = $isActive(['admin.testimonials', 'admin.discounts', 'admin.coupons', 'admin.gift-cards', 'admin.contacts', 'admin.consultations', 'admin.blogs', 'admin.pages', 'admin.subscribers', 'admin.email-templates', 'admin.bulk-email']);
    $isManagementActive = $isActive(['admin.clients', 'admin.users', 'admin.resellers']);
    $isDeliveryActive = $isActive(['admin.delivery-agents']);
    $isReportsActive = $isActive(['admin.reports']);
    $isSettingsActive = $isActive(['admin.settings', 'admin.roles', 'admin.system-errors', 'admin.profile', 'admin.stores']);
@endphp

<!-- Ensure Alpine Collapse is loaded for sidebar animations -->
<script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/collapse@3.x.x/dist/cdn.min.js"></script>

<aside
    class="w-64 bg-slate-900 hidden md:flex flex-col transition-all duration-300 border-r border-slate-800 h-screen font-sans shadow-xl z-30">

    <!-- Brand -->
    <div class="h-20 flex items-center justify-center border-b border-slate-800/50 bg-slate-900 sticky top-0 z-20">
        <a href="{{ route('admin.dashboard') }}" class="flex items-center gap-3 group">
            <div
                class="w-10 h-10 rounded-xl bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center shadow-lg shadow-indigo-500/20 group-hover:scale-105 transition-transform duration-200">
                <span class="text-white font-extrabold text-xl">L</span>
            </div>
            <div class="flex flex-col">
                <span class="text-lg font-bold text-white tracking-wide leading-none">Hair Niche</span>
                <span class="text-[10px] text-slate-400 font-medium tracking-wider uppercase">Admin Panel</span>
            </div>
        </a>
    </div>

    <!-- Navigation -->
    <nav class="flex-1 overflow-y-auto py-6 px-4 space-y-1.5 custom-scrollbar">

        <!-- Dashboard -->
        <a href="{{ route('admin.dashboard') }}"
            class="flex items-center px-4 py-3 rounded-xl transition-all duration-200 group {{ $currentRoute == 'admin.dashboard' ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/20' : 'text-slate-400 hover:bg-slate-800/50 hover:text-white' }}">
            <svg class="w-5 h-5 mr-3 transition-colors {{ $currentRoute == 'admin.dashboard' ? 'text-white' : 'text-slate-500 group-hover:text-white' }}"
                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
            </svg>
            <span class="font-medium text-sm">Dashboard</span>
        </a>

        <!-- Leadership Board -->
        <a href="{{ route('admin.leadership-board.index') }}"
            class="flex items-center px-4 py-3 rounded-xl transition-all duration-200 group {{ $currentRoute == 'admin.leadership-board.index' ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/20' : 'text-slate-400 hover:bg-slate-800/50 hover:text-white' }}">
            <svg class="w-5 h-5 mr-3 transition-colors {{ $currentRoute == 'admin.leadership-board.index' ? 'text-white' : 'text-slate-500 group-hover:text-white' }}"
                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
            </svg>
            <span class="font-medium text-sm">Leadership Board</span>
        </a>

        <!-- AI Chatbot -->
        <a href="{{ route('admin.chatbot.index') }}"
            class="flex items-center px-4 py-3 rounded-xl transition-all duration-200 group {{ Str::startsWith($currentRoute, 'admin.chatbot') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/20' : 'text-slate-400 hover:bg-slate-800/50 hover:text-white' }}">
            <svg class="w-5 h-5 mr-3 transition-colors {{ Str::startsWith($currentRoute, 'admin.chatbot') ? 'text-white' : 'text-slate-500 group-hover:text-white' }}"
                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M19 11a7 7 0 01-7 7m0 0a7 7 0 01-7-7m7 7v4m0 0H8m4 0h4m-4-8a3 3 0 01-3-3V5a3 3 0 116 0v6a3 3 0 01-3 3z" />
            </svg>
            <span class="font-medium text-sm">AI Chatbot</span>
        </a>

        <!-- Section Label -->
        <div class="pt-4 pb-2 px-4 text-xs font-bold text-slate-600 uppercase tracking-wider">
            Ecommerce
        </div>

        <!-- Catalog Section -->
        <div x-data="{ open: {{ $isCatalogActive ? 'true' : 'false' }} }" class="space-y-1">
            <button @click="open = !open"
                class="w-full flex items-center justify-between px-4 py-3 rounded-xl text-slate-400 hover:bg-slate-800/50 hover:text-white transition-all duration-200 group {{ $isCatalogActive ? 'text-white bg-slate-800/30' : '' }}">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-3 {{ $isCatalogActive ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }} transition-colors"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                    </svg>
                    <span class="font-medium text-sm">Catalog & Orders</span>
                </div>
                <svg class="w-4 h-4 transition-transform duration-200 text-slate-500"
                    :class="{'rotate-90 text-white': open}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </button>
            <div x-show="open" x-collapse class="pl-4 space-y-1">
                <div class="border-l-2 border-slate-700 ml-3 pl-3 py-1 space-y-1">
                    <a href="{{ route('admin.orders.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ $currentRoute == 'admin.orders.index' && !request('assigned') && !request('role') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">
                        All Orders
                    </a>
                    <a href="{{ route('admin.orders.index', ['role' => 'Reseller']) }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ request('role') == 'Reseller' ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">
                        Reseller Orders
                    </a>
                    @if(auth()->user()->hasPermission('view_returns'))
                        <a href="{{ route('admin.returns.index') }}"
                            class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.returns') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">
                            Manage Returns
                        </a>
                    @endif
                    <a href="{{ route('admin.products.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.products') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">
                        Products
                    </a>
                    <a href="{{ route('admin.categories.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.categories') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">
                        Categories
                    </a>
                    <a href="{{ route('admin.tickets.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.tickets') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">
                        Support Tickets
                    </a>
                </div>
            </div>
        </div>

        <!-- Marketing Section -->
        <div x-data="{ open: {{ $isMarketingActive ? 'true' : 'false' }} }" class="space-y-1">
            <button @click="open = !open"
                class="w-full flex items-center justify-between px-4 py-3 rounded-xl text-slate-400 hover:bg-slate-800/50 hover:text-white transition-all duration-200 group {{ $isMarketingActive ? 'text-white bg-slate-800/30' : '' }}">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-3 {{ $isMarketingActive ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }} transition-colors"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
                    </svg>
                    <span class="font-medium text-sm">Marketing</span>
                </div>
                <svg class="w-4 h-4 transition-transform duration-200 text-slate-500"
                    :class="{'rotate-90 text-white': open}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </button>
            <div x-show="open" x-collapse class="pl-4 space-y-1">
                <div class="border-l-2 border-slate-700 ml-3 pl-3 py-1 space-y-1">
                    <a href="{{ route('admin.discounts.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.discounts') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Discounts</a>
                    <a href="{{ route('admin.coupons.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.coupons') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Coupons</a>
                    <a href="{{ route('admin.gift-cards.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.gift-cards') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Gift
                        Cards</a>
                    <a href="{{ route('admin.testimonials.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.testimonials') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Testimonials</a>
                    <a href="{{ route('admin.blogs.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.blogs') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Blog
                        Posts</a>
                    <a href="{{ route('admin.pages.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.pages') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Content
                        Pages</a>
                    <a href="{{ route('admin.subscribers.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.subscribers') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Subscribers</a>
                    <a href="{{ route('admin.contacts.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.contacts') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Queries</a>
                    <a href="{{ route('admin.consultations.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.consultations') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Video
                        Consultations</a>
                    <a href="{{ route('admin.email-templates.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.email-templates') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Email
                        Templates</a>
                    <a href="{{ route('admin.bulk-email.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.bulk-email') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Bulk
                        Email</a>
                </div>
            </div>
        </div>

        <div class="pt-4 pb-2 px-4 text-xs font-bold text-slate-600 uppercase tracking-wider">
            Administration
        </div>

        <!-- Management Section -->
        <div x-data="{ open: {{ $isManagementActive ? 'true' : 'false' }} }" class="space-y-1">
            <button @click="open = !open"
                class="w-full flex items-center justify-between px-4 py-3 rounded-xl text-slate-400 hover:bg-slate-800/50 hover:text-white transition-all duration-200 group {{ $isManagementActive ? 'text-white bg-slate-800/30' : '' }}">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-3 {{ $isManagementActive ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }} transition-colors"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                    <span class="font-medium text-sm">User Management</span>
                </div>
                <svg class="w-4 h-4 transition-transform duration-200 text-slate-500"
                    :class="{'rotate-90 text-white': open}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </button>
            <div x-show="open" x-collapse class="pl-4 space-y-1">
                <div class="border-l-2 border-slate-700 ml-3 pl-3 py-1 space-y-1">
                    <a href="{{ route('admin.resellers.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.resellers') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Resellers</a>
                    <a href="{{ route('admin.clients.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.clients') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Clients</a>
                    <a href="{{ route('admin.users.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.users') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">System
                        Users</a>

                </div>
            </div>
        </div>

        <!-- Delivery Section -->
        <div x-data="{ open: {{ $isDeliveryActive ? 'true' : 'false' }} }" class="space-y-1">
            <button @click="open = !open"
                class="w-full flex items-center justify-between px-4 py-3 rounded-xl text-slate-400 hover:bg-slate-800/50 hover:text-white transition-all duration-200 group {{ $isDeliveryActive ? 'text-white bg-slate-800/30' : '' }}">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-3 {{ $isDeliveryActive ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }} transition-colors"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path d="M9 17a2 2 0 11-4 0 2 2 0 014 0zM19 17a2 2 0 11-4 0 2 2 0 014 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 104 0m-4 0a2 2 0 114 0m6 0a2 2 0 104 0m-4 0a2 2 0 114 0" />
                    </svg>
                    <span class="font-medium text-sm">Logistics</span>
                </div>
                <svg class="w-4 h-4 transition-transform duration-200 text-slate-500"
                    :class="{'rotate-90 text-white': open}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </button>
            <div x-show="open" x-collapse class="pl-4 space-y-1">
                <div class="border-l-2 border-slate-700 ml-3 pl-3 py-1 space-y-1">
                    <a href="{{ route('admin.delivery-agents.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.delivery-agents') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Delivery
                        Agents</a>
                    <a href="{{ route('admin.orders.index', ['assigned' => 1]) }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ request('assigned') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Active
                        Deliveries</a>
                </div>
            </div>
        </div>

        <!-- Reports Section -->
        <div x-data="{ open: {{ $isReportsActive ? 'true' : 'false' }} }" class="space-y-1">
            <button @click="open = !open"
                class="w-full flex items-center justify-between px-4 py-3 rounded-xl text-slate-400 hover:bg-slate-800/50 hover:text-white transition-all duration-200 group {{ $isReportsActive ? 'text-white bg-slate-800/30' : '' }}">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-3 {{ $isReportsActive ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }} transition-colors"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                    </svg>
                    <span class="font-medium text-sm">Reports</span>
                </div>
                <svg class="w-4 h-4 transition-transform duration-200 text-slate-500"
                    :class="{'rotate-90 text-white': open}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </button>
            <div x-show="open" x-collapse class="pl-4 space-y-1">
                <div class="border-l-2 border-slate-700 ml-3 pl-3 py-1 space-y-1">
                    <a href="{{ route('admin.reports.orders', 'pending') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all text-slate-500 hover:text-slate-300 hover:translate-x-1">Pending
                        Orders</a>
                    <a href="{{ route('admin.reports.orders', 'completed') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all text-slate-500 hover:text-slate-300 hover:translate-x-1">Completed
                        Orders</a>
                    <a href="{{ route('admin.reports.payments') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.reports.payments') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Payment
                        Reports</a>
                    <a href="{{ route('admin.reports.traffic') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.reports.traffic') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Traffic
                        Analysis</a>
                    <a href="{{ route('admin.reports.shipping') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.reports.shipping') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Shipping
                        Reports</a>
                    <a href="{{ route('admin.reports.tax') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.reports.tax') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Tax
                        Reports</a>
                    @if(auth()->user()->hasPermission('view_refund_reports'))
                        <a href="{{ route('admin.reports.refunds') }}"
                            class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.reports.refunds') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Refund
                            Reports</a>
                    @endif
                    <a href="{{ route('admin.analytics.funnel') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.analytics.funnel') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Funnel
                        Analytics</a>
                </div>
            </div>
        </div>

        <!-- Settings Section -->
        <div x-data="{ open: {{ $isSettingsActive ? 'true' : 'false' }} }" class="space-y-1">
            <button @click="open = !open"
                class="w-full flex items-center justify-between px-4 py-3 rounded-xl text-slate-400 hover:bg-slate-800/50 hover:text-white transition-all duration-200 group {{ $isSettingsActive ? 'text-white bg-slate-800/30' : '' }}">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-3 {{ $isSettingsActive ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }} transition-colors"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                    <span class="font-medium text-sm">System Settings</span>
                </div>
                <svg class="w-4 h-4 transition-transform duration-200 text-slate-500"
                    :class="{'rotate-90 text-white': open}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </button>
            <div x-show="open" x-collapse class="pl-4 space-y-1">
                <div class="border-l-2 border-slate-700 ml-3 pl-3 py-1 space-y-1">
                    <a href="{{ route('admin.settings.website.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.website') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Website</a>
                    <a href="{{ route('admin.settings.appearance.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.appearance') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Appearance</a>
                    <a href="{{ route('admin.settings.cart.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.cart') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Shopping
                        Cart</a>
                    <a href="{{ route('admin.settings.store.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.store') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Store
                        Info</a>
                    <a href="{{ route('admin.stores.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.stores') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Stores</a>
                    <a href="{{ route('admin.settings.sliders.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.sliders') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Sliders</a>
                    <a href="{{ route('admin.settings.promotional.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.promotional') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Promotional
                        Banners</a>
                    <a href="{{ route('admin.settings.custom_offers.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.custom_offers') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Custom
                        Offers</a>
                    <a href="{{ route('admin.roles.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.roles') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Roles
                        & Permissions</a>
                    <a href="{{ route('admin.settings.shipping.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all text-slate-500 hover:text-slate-300 hover:translate-x-1">Shipping</a>
                    <a href="{{ route('admin.settings.seo.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.seo') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">SEO</a>
                    <a href="{{ route('admin.settings.analytics.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.analytics') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Analytics</a>
                    <a href="{{ route('admin.settings.policy.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.policy') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Policy
                        Pages</a>
                    <a href="{{ route('admin.settings.developer.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.developer') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Advanced
                        (Dev)</a>
                    <a href="{{ route('admin.settings.tax.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.tax') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Tax
                        Settings</a>

                    <a href="{{ route('admin.settings.payment.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all text-slate-500 hover:text-slate-300 hover:translate-x-1">Payments</a>
                    <a href="{{ route('admin.settings.gateway.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all text-slate-500 hover:text-slate-300 hover:translate-x-1">Payment
                        Gateway</a>
                    <a href="{{ route('admin.settings.wallet.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all text-slate-500 hover:text-slate-300 hover:translate-x-1">Wallet</a>
                    <a href="{{ route('admin.settings.notification.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.notification') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Notifications</a>
                    <a href="{{ route('admin.settings.logistics.show') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.settings.logistics') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">Logistics</a>
                    <a href="{{ route('admin.profile.edit') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ $currentRoute == 'admin.profile.edit' ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">My
                        Profile</a>
                    <a href="{{ route('admin.system-errors.index') }}"
                        class="block px-3 py-2 rounded-lg text-sm transition-all {{ Str::startsWith($currentRoute, 'admin.system-errors') ? 'text-white bg-indigo-500/20 translate-x-1' : 'text-slate-500 hover:text-slate-300 hover:translate-x-1' }}">System
                        Logs</a>
                </div>
            </div>
        </div>

    </nav>

    <!-- User Footer -->
    <div class="p-4 bg-slate-900 border-t border-slate-800">
        <form action="{{ route('admin.logout') }}" method="POST">
            @csrf
            <button
                class="flex items-center w-full px-4 py-3 rounded-xl bg-slate-800 text-slate-400 hover:bg-red-500 hover:text-white transition-all duration-200 group shadow-md hover:shadow-red-500/20">
                <svg class="w-5 h-5 mr-3 group-hover:text-white transition-colors" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
                <span class="font-medium text-sm">Sign Out</span>
            </button>
        </form>
    </div>
</aside>

<style>
    .custom-scrollbar::-webkit-scrollbar {
        width: 4px;
    }

    .custom-scrollbar::-webkit-scrollbar-track {
        background: transparent;
    }

    .custom-scrollbar::-webkit-scrollbar-thumb {
        background: #334155;
        border-radius: 4px;
    }

    .custom-scrollbar::-webkit-scrollbar-thumb:hover {
        background: #475569;
    }
</style>