<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Orders - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Orders</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <!-- Filter/Search Toolbar -->
                <div
                    class="p-4 border-b border-gray-200 flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
                    <div class="flex flex-wrap gap-2">
                        <a href="{{ request()->fullUrlWithQuery(['status' => null, 'page' => null]) }}"
                            class="px-3 py-1 rounded-full text-xs font-semibold {{ !request('status') ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">All
                            ({{ $counts['all'] }})</a>
                        <a href="{{ request()->fullUrlWithQuery(['status' => 'pending', 'page' => null]) }}"
                            class="px-3 py-1 rounded-full text-xs font-semibold {{ request('status') == 'pending' ? 'bg-amber-100 text-amber-800' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Pending
                            ({{ $counts['pending'] }})</a>
                        <a href="{{ request()->fullUrlWithQuery(['status' => 'processing', 'page' => null]) }}"
                            class="px-3 py-1 rounded-full text-xs font-semibold {{ request('status') == 'processing' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Processing
                            ({{ $counts['processing'] }})</a>
                        <a href="{{ request()->fullUrlWithQuery(['status' => 'shipped', 'page' => null]) }}"
                            class="px-3 py-1 rounded-full text-xs font-semibold {{ request('status') == 'shipped' ? 'bg-indigo-100 text-indigo-800' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Shipped
                            ({{ $counts['shipped'] }})</a>
                        <a href="{{ request()->fullUrlWithQuery(['status' => 'completed', 'page' => null]) }}"
                            class="px-3 py-1 rounded-full text-xs font-semibold {{ request('status') == 'completed' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Completed
                            ({{ $counts['completed'] }})</a>
                        <a href="{{ request()->fullUrlWithQuery(['status' => 'cancelled', 'page' => null]) }}"
                            class="px-3 py-1 rounded-full text-xs font-semibold {{ request('status') == 'cancelled' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Cancelled
                            ({{ $counts['cancelled'] }})</a>
                        <a href="{{ request()->fullUrlWithQuery(['status' => 'returned', 'page' => null]) }}"
                            class="px-3 py-1 rounded-full text-xs font-semibold {{ request('status') == 'returned' ? 'bg-purple-100 text-purple-800' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Returned
                            ({{ $counts['returned'] }})</a>
                    </div>

                    <form action="{{ route('admin.orders.index') }}" method="GET"
                        class="relative w-full md:w-auto flex flex-col md:flex-row space-y-2 md:space-y-0 md:space-x-2">
                        @if(request('status'))
                            <input type="hidden" name="status" value="{{ request('status') }}">
                        @endif

                        <div class="flex items-center space-x-1">
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="w-full md:w-36 pl-2 pr-2 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-blue-500"
                                placeholder="Start Date">
                            <span class="text-gray-500">-</span>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="w-full md:w-36 pl-2 pr-2 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-blue-500"
                                placeholder="End Date">
                        </div>

                        <div class="relative">
                            <input type="text" name="search" value="{{ request('search') }}"
                                placeholder="Search orders..."
                                class="w-full md:w-64 pl-3 pr-10 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-blue-500">
                            <button type="submit"
                                class="absolute right-0 top-0 mt-2 mr-3 text-gray-400 hover:text-gray-600">
                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Order</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Date</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Customer</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Total</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Type</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Payment</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Status</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Agent</th>
                                <th
                                    class="px-3 py-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($orders as $order)
                                                        <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-3 py-2 whitespace-nowrap text-xs font-medium text-blue-600">
                                        <a href="{{ route('admin.orders.show', ['order' => $order->id, 'role' => request('role')]) }}">
                                            {{ $order->order_number }}
                                        </a>
                                    </td>
                                                            <td class="px-3 py-2 whitespace-nowrap text-xs text-gray-500">
                                                                {{ $order->created_at->format('M d, H:i') }}
                                                            </td>
                                                            <td class="px-3 py-2 whitespace-nowrap text-xs text-gray-500">
                                                                @if($order->user)
                                                                    <div class="text-gray-900 font-medium">{{ $order->user->name }}</div>
                                                                    <div class="text-[10px] text-gray-400">{{ Str::limit($order->user->email, 20) }}</div>
                                                                @else
                                                                    <div class="text-gray-900 font-medium">{{ $order->name }} (Guest)</div>
                                                                    <div class="text-[10px] text-gray-400">{{ Str::limit($order->email, 20) }}</div>
                                                                @endif
                                                            </td>
                                                            <td class="px-3 py-2 whitespace-nowrap text-xs text-gray-900 font-bold">
                                                                ₹{{ number_format($order->total, 2) }}
                                                            </td>
                                                            <td class="px-3 py-2 whitespace-nowrap text-xs text-gray-500">
                                                                <span class="px-2 py-0.5 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                                                                            {{ match ($order->order_scope) {
                                    'International' => 'bg-purple-100 text-purple-800',
                                    'National' => 'bg-orange-100 text-orange-800',
                                    'Local' => 'bg-cyan-100 text-cyan-800',
                                    default => 'bg-gray-100 text-gray-800'
                                } }}">
                                                                    {{ $order->order_scope }}
                                                                </span>
                                                            </td>
                                                            <td class="px-3 py-2 whitespace-nowrap text-xs text-gray-500 capitalize">
                                                                {{ $order->payment_method ?? '-' }}
                                                                <span class="text-[10px]">({{ $order->payment_status }})</span>
                                                            </td>
                                                            <td class="px-3 py-2 whitespace-nowrap">
                                                                <span class="px-2 py-0.5 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                                                                                                                                                                                                                {{ match ($order->status) {
                                    'completed' => 'bg-green-100 text-green-800',
                                    'processing' => 'bg-blue-100 text-blue-800',
                                    'shipped' => 'bg-indigo-100 text-indigo-800',
                                    'cancelled' => 'bg-red-100 text-red-800',
                                    default => 'bg-gray-100 text-gray-800'
                                } }}">
                                                                    {{ ucfirst($order->status) }}
                                                                </span>

                                                                @if($order->agentRating || $order->productReviews->isNotEmpty())
                                                                    @php
                                                                        $avgRating = 0;
                                                                        $totalRatings = 0;
                                                                        if($order->agentRating) {
                                                                            $avgRating += $order->agentRating->rating;
                                                                            $totalRatings++;
                                                                        }
                                                                        foreach($order->productReviews as $pr) {
                                                                            $avgRating += $pr->rating;
                                                                            $totalRatings++;
                                                                        }
                                                                        $finalAvg = $totalRatings > 0 ? round($avgRating / $totalRatings, 1) : 0;
                                                                    @endphp
                                                                    <div class="mt-1">
                                                                        <a href="{{ route('admin.orders.show', $order->id) }}" 
                                                                           class="inline-flex items-center px-1.5 py-0.5 rounded-full text-[9px] font-bold uppercase tracking-wider border bg-amber-50 text-amber-700 border-amber-200 hover:bg-amber-100 transition-colors">
                                                                            <svg class="w-2.5 h-2.5 fill-current mr-0.5" viewBox="0 0 20 20">
                                                                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                                            </svg>
                                                                            {{ $finalAvg }}
                                                                        </a>
                                                                    </div>
                                                                @endif
                                                            </td>
                                                            <td class="px-3 py-2 whitespace-nowrap text-xs text-gray-500">
                                                                @if($order->deliveryAgent)
                                                                    <div class="flex items-center">
                                                                        <div class="text-xs font-medium text-gray-900">{{ Str::limit($order->deliveryAgent->user->name ?? 'Unknown', 15) }}</div>
                                                                    </div>
                                                                @else
                                                                    <span class="text-gray-400 text-[10px] italic">Unassigned</span>
                                                                @endif
                                                            </td>
                                                            <td class="px-3 py-2 whitespace-nowrap text-right text-xs font-medium">
                                    <a href="{{ route('admin.orders.show', ['order' => $order->id, 'role' => request('role')]) }}"
                                        class="text-indigo-600 hover:text-indigo-900" title="View Order">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                    </a>
                                </td>
                                                        </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-10 text-center text-gray-500">
                                        No orders found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                    {{ $orders->withQueryString()->links() }}
                </div>
            </div>
        </main>
    </div>
</body>

</html>