<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Revenue Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 12px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
        }

        .header p {
            margin: 5px 0;
            color: #666;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            padding: 8px;
            text-align: right;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #f8f8f8;
            color: #333;
            font-weight: bold;
            border-top: 1px solid #ddd;
        }

        td.text-left {
            text-align: left;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 10px;
            font-size: 10px;
            text-align: center;
            color: #999;
        }

        .summary {
            margin-top: 20px;
            text-align: right;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Revenue Report</h1>
        <p>Period: {{ $startDate->format('F d, Y') }} - {{ $endDate->format('F d, Y') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-left">Date</th>
                <th>Orders</th>
                <th>Gross Sales</th>
                <th>Returns</th>
                <th>Coupons</th>
                <th>Net Sales</th>
                <th>Taxes</th>
                <th>Shipping</th>
                <th>Total Sales</th>
            </tr>
        </thead>
        <tbody>
            @foreach($revenueData as $row)
                <tr>
                    <td class="text-left">{{ $row['date']->format('M d, Y') }}</td>
                    <td>{{ $row['orders'] }}</td>
                    <td>{{ number_format($row['gross_sales'], 2) }}</td>
                    <td>{{ number_format($row['returns'], 2) }}</td>
                    <td>{{ number_format($row['coupons'], 2) }}</td>
                    <td>{{ number_format($row['net_sales'], 2) }}</td>
                    <td>{{ number_format($row['taxes'], 2) }}</td>
                    <td>{{ number_format($row['shipping'], 2) }}</td>
                    <td><strong>{{ number_format($row['total_sales'], 2) }}</strong></td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        Generated on {{ now()->format('Y-m-d H:i') }}
    </div>
</body>

</html>