<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error Details - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
    </style>
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <div class="flex items-center gap-4">
                <a href="{{ route('admin.system-errors.index') }}"
                    class="p-2 bg-slate-50 text-slate-400 hover:text-[#0f172a] rounded-xl transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                </a>
                <div>
                    <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">Error Details</h2>
                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Stack trace and
                        environment analysis</p>
                </div>
            </div>

            <div class="flex items-center gap-3">
                @if(!$error->is_resolved)
                    <form action="{{ route('admin.system-errors.resolve', $error) }}" method="POST">
                        @csrf
                        <button type="submit"
                            class="px-6 py-2 bg-emerald-600 text-white rounded-xl text-[10px] font-black uppercase tracking-widest shadow-xl shadow-emerald-200 hover:scale-105 transition-all">
                            Mark as Resolved
                        </button>
                    </form>
                @endif
                <form action="{{ route('admin.system-errors.destroy', $error) }}" method="POST"
                    onsubmit="return confirm('Delete this log permanently?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit"
                        class="px-6 py-2 bg-red-50 text-red-600 rounded-xl text-[10px] font-black uppercase tracking-widest border border-red-100 hover:bg-red-600 hover:text-white transition-all">
                        Delete Log
                    </button>
                </form>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-slate-50/50 p-8">
            <div class="max-w-6xl mx-auto space-y-6">
                <!-- Summary Card -->
                <div class="bg-white p-8 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20">
                    <div class="flex flex-col gap-6">
                        <div>
                            <span
                                class="px-2 py-1 bg-blue-50 text-blue-600 rounded-lg text-[10px] font-black uppercase tracking-widest mb-2 inline-block">{{ $error->exception_class }}</span>
                            <h3 class="text-2xl font-black text-[#0f172a] tracking-tight leading-tight">
                                {{ $error->message }}</h3>
                        </div>

                        <div class="grid grid-cols-2 lg:grid-cols-4 gap-8">
                            <div class="space-y-1">
                                <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Request
                                    URL</span>
                                <p class="text-xs font-bold text-slate-600 break-all">{{ $error->url }}</p>
                            </div>
                            <div class="space-y-1">
                                <span
                                    class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Method</span>
                                <p class="text-xs font-bold text-slate-600">{{ $error->method }}</p>
                            </div>
                            <div class="space-y-1">
                                <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">IP
                                    Address</span>
                                <p class="text-xs font-bold text-slate-600">{{ $error->ip_address }}</p>
                            </div>
                            <div class="space-y-1">
                                <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Triggered
                                    At</span>
                                <p class="text-xs font-bold text-slate-600">
                                    {{ $error->created_at->format('M d, Y H:i:s') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- User Agent Card -->
                <div class="bg-white p-6 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20">
                    <h4 class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-2">User Agent</h4>
                    <p class="text-xs font-medium text-slate-500 bg-slate-50 p-4 rounded-xl">{{ $error->user_agent }}
                    </p>
                </div>

                <!-- Stack Trace -->
                <div
                    class="bg-[#1e293b] p-8 rounded-[2rem] border border-slate-800 shadow-2xl overflow-hidden relative">
                    <div class="absolute top-6 right-8">
                        <span class="text-[10px] font-black text-slate-500 uppercase tracking-widest">Stack Trace</span>
                    </div>
                    <pre
                        class="text-[11px] leading-relaxed text-slate-300 overflow-x-auto custom-scrollbar font-mono">{{ $error->stack_trace }}</pre>
                </div>
            </div>
        </main>
    </div>

    <style>
        .custom-scrollbar::-webkit-scrollbar {
            height: 8px;
            width: 0px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: #1e293b;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #334155;
            border-radius: 4px;
        }
    </style>
</body>

</html>