<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Error Logs - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
    </style>
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <div>
                <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">System Error Logs</h2>
                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Monitor and debug application
                    exceptions</p>
            </div>

            <form action="{{ route('admin.system-errors.clear-all') }}" method="POST"
                onsubmit="return confirm('Clear all error logs?')">
                @csrf
                <button type="submit"
                    class="px-4 py-2 bg-red-50 text-red-600 rounded-xl text-[10px] font-black uppercase tracking-widest border border-red-100 hover:bg-red-600 hover:text-white transition-all">
                    Clear All Logs
                </button>
            </form>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-white p-8">
            <div class="bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 overflow-hidden">
                <table class="w-full">
                    <thead class="bg-slate-50/50">
                        <tr class="text-[10px] font-black text-slate-400 uppercase tracking-widest">
                            <th class="px-6 py-4 text-left">Status</th>
                            <th class="px-6 py-4 text-left">Exception / Message</th>
                            <th class="px-6 py-4 text-left">URL / Method</th>
                            <th class="px-6 py-4 text-left">User</th>
                            <th class="px-6 py-4 text-right">Time</th>
                            <th class="px-6 py-4 text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        @forelse($errors as $error)
                            <tr
                                class="hover:bg-slate-50/50 transition-colors {{ $error->is_resolved ? 'opacity-50' : '' }}">
                                <td class="px-6 py-5">
                                    @if($error->is_resolved)
                                        <span
                                            class="px-2 py-1 bg-emerald-50 text-emerald-600 rounded-lg text-[10px] font-black uppercase tracking-widest">Resolved</span>
                                    @else
                                        <span
                                            class="px-2 py-1 bg-red-50 text-red-600 rounded-lg text-[10px] font-black uppercase tracking-widest">Active</span>
                                    @endif
                                </td>
                                <td class="px-6 py-5">
                                    <div class="flex flex-col">
                                        <span
                                            class="text-[10px] font-black text-blue-600 uppercase tracking-tight">{{ class_basename($error->exception_class) }}</span>
                                        <span class="text-xs font-bold text-[#0f172a] line-clamp-1 max-w-[300px]"
                                            title="{{ $error->message }}">{{ $error->message }}</span>
                                    </div>
                                </td>
                                <td class="px-6 py-5">
                                    <div class="flex flex-col">
                                        <span
                                            class="text-[10px] font-black text-slate-400 uppercase tracking-tight">{{ $error->method }}</span>
                                        <span class="text-xs font-bold text-slate-600 truncate max-w-[200px]"
                                            title="{{ $error->url }}">{{ str_replace(config('app.url'), '', $error->url) ?: '/' }}</span>
                                    </div>
                                </td>
                                <td class="px-6 py-5 text-xs font-bold text-slate-500">
                                    {{ $error->user ? $error->user->name : 'Guest' }}
                                </td>
                                <td class="px-6 py-5 text-right">
                                    <span
                                        class="text-xs font-bold text-slate-400">{{ $error->created_at->diffForHumans() }}</span>
                                </td>
                                <td class="px-6 py-5 text-center">
                                    <div class="flex items-center justify-center gap-2">
                                        <a href="{{ route('admin.system-errors.show', $error) }}"
                                            class="p-2 bg-slate-50 text-slate-600 hover:bg-blue-600 hover:text-white rounded-lg transition-all">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                            </svg>
                                        </a>
                                        @if(!$error->is_resolved)
                                            <form action="{{ route('admin.system-errors.resolve', $error) }}" method="POST">
                                                @csrf
                                                <button type="submit"
                                                    class="p-2 bg-slate-50 text-emerald-600 hover:bg-emerald-600 hover:text-white rounded-lg transition-all">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M5 13l4 4L19 7" />
                                                    </svg>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6"
                                    class="px-6 py-16 text-center text-[10px] font-bold text-slate-400 uppercase tracking-widest italic">
                                    No system errors recorded.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6">
                {{ $errors->links() }}
            </div>
        </main>
    </div>
</body>

</html>