<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Preview Template - {{ $emailTemplate->name }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
    </style>
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">Preview:
                {{ $emailTemplate->name }}</h2>
            <div class="flex items-center gap-4">
                <a href="{{ route('admin.email-templates.edit', $emailTemplate->id) }}"
                    class="text-blue-600 hover:text-blue-800 transition-all font-bold text-sm uppercase tracking-widest">Edit</a>
                <a href="{{ route('admin.email-templates.index') }}"
                    class="text-slate-400 hover:text-[#0f172a] transition-all font-bold text-sm uppercase tracking-widest">Back
                    to List</a>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-slate-50 p-8">
            <div class="max-w-4xl mx-auto space-y-6">
                <!-- Meta Info -->
                <div
                    class="bg-white rounded-2xl p-6 shadow-sm border border-slate-100 grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <span
                            class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Subject</span>
                        <p class="font-bold text-[#0f172a]">{{ $emailTemplate->subject }}</p>
                    </div>
                    <div>
                        <span
                            class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Category</span>
                        <span
                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                            {{ $emailTemplate->category }}
                        </span>
                    </div>
                    <div>
                        <span class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Target
                            Role</span>
                        <span
                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                            {{ $emailTemplate->target_role }}
                        </span>
                    </div>
                </div>

                <!-- Preview Area -->
                <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                    <div class="bg-slate-50 border-b border-slate-100 px-6 py-4 flex items-center justify-between">
                        <h3 class="font-bold text-sm text-[#0f172a] uppercase tracking-wider">Email Content Preview</h3>
                    </div>
                    <div class="p-8 bg-white">
                        <!-- Render HTML Content Safely -->
                        <div class="prose max-w-none">
                            {!! $emailTemplate->content !!}
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>

</html>