<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Email Template - Hair Niche Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
    </style>
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">Edit Template:
                {{ $emailTemplate->name }}
            </h2>
            <a href="{{ route('admin.email-templates.index') }}"
                class="text-slate-400 hover:text-[#0f172a] transition-all font-bold text-sm uppercase tracking-widest pl-4">Back
                to List</a>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-white p-8">
            <form action="{{ route('admin.email-templates.update', $emailTemplate->id) }}" method="POST"
                class="max-w-4xl"
                x-data="{ category: '{{ in_array($emailTemplate->category, $categories) ? $emailTemplate->category : 'other' }}' }">
                @csrf
                @method('PUT')
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                    <div class="space-y-6">
                        <div>
                            <label
                                class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-2">Template
                                Name</label>
                            <input type="text" name="name" value="{{ old('name', $emailTemplate->name) }}"
                                class="w-full px-5 py-3 rounded-2xl border border-slate-100 bg-slate-50/50 focus:bg-white focus:border-blue-600 outline-none transition-all font-bold text-sm"
                                required>
                            @error('name') <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label
                                class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-2">Email
                                Subject</label>
                            <input type="text" name="subject" value="{{ old('subject', $emailTemplate->subject) }}"
                                class="w-full px-5 py-3 rounded-2xl border border-slate-100 bg-slate-50/50 focus:bg-white focus:border-blue-600 outline-none transition-all font-bold text-sm"
                                required>
                            @error('subject') <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <div class="space-y-6">
                        <div>
                            <label
                                class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-2">Send
                                To (Role)</label>
                            <select name="target_role"
                                class="w-full px-5 py-3 rounded-2xl border border-slate-100 bg-slate-50/50 focus:bg-white focus:border-blue-600 outline-none transition-all font-bold text-sm"
                                required>
                                <option value="">Select Recipient Role</option>
                                <option value="Admin" {{ old('target_role', $emailTemplate->target_role) == 'Admin' ? 'selected' : '' }}>Admin</option>
                                <option value="Agents" {{ old('target_role', $emailTemplate->target_role) == 'Agents' ? 'selected' : '' }}>Agents</option>
                                <option value="Clients" {{ old('target_role', $emailTemplate->target_role) == 'Clients' ? 'selected' : '' }}>Clients</option>
                                <option value="Resellers" {{ old('target_role', $emailTemplate->target_role) == 'Resellers' ? 'selected' : '' }}>Resellers</option>
                            </select>
                            @error('target_role') <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label
                                class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-2">Category</label>
                            <select name="category" x-model="category"
                                class="w-full px-5 py-3 rounded-2xl border border-slate-100 bg-slate-50/50 focus:bg-white focus:border-blue-600 outline-none transition-all font-bold text-sm"
                                required>
                                <option value="">Select Category</option>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat }}">{{ $cat }}</option>
                                @endforeach
                                <option value="other">Add New Category</option>
                            </select>
                            @error('category') <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                            @enderror
                        </div>

                        <div x-show="category === 'other'" x-cloak>
                            <label
                                class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-2">Custom
                                Category Name</label>
                            <input type="text" name="custom_category"
                                value="{{ !in_array($emailTemplate->category, $categories) ? $emailTemplate->category : '' }}"
                                class="w-full px-5 py-3 rounded-2xl border border-slate-100 bg-slate-50/50 focus:bg-white focus:border-blue-600 outline-none transition-all font-bold text-sm"
                                placeholder="Enter category name">
                            @error('custom_category') <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex items-center gap-3">
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="is_active" value="1" {{ $emailTemplate->is_active ? 'checked' : '' }} class="sr-only peer">
                                <div
                                    class="w-11 h-6 bg-slate-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600">
                                </div>
                            </label>
                            <span class="text-xs font-bold text-slate-600 uppercase tracking-widest">Active
                                Template</span>
                        </div>
                    </div>
                </div>

                <div class="mb-8">
                    <label class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-2">Email
                        Content (HTML)</label>
                    <textarea name="content" id="editor" rows="15"
                        class="w-full px-5 py-4 rounded-[2rem] border border-slate-100 bg-slate-50/50 focus:bg-white focus:border-blue-600 outline-none transition-all font-mono text-sm"
                        required>{{ old('content', $emailTemplate->content) }}</textarea>
                    @error('content') <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                </div>

                <div class="flex gap-4">
                    <button type="submit"
                        class="bg-blue-600 text-white px-10 py-4 rounded-2xl font-black text-xs uppercase tracking-widest shadow-xl shadow-blue-100 hover:bg-blue-700 transition-all">Update
                        Template</button>
                    <a href="{{ route('admin.email-templates.index') }}"
                        class="bg-slate-100 text-slate-600 px-10 py-4 rounded-2xl font-black text-xs uppercase tracking-widest hover:bg-slate-200 transition-all">Cancel</a>
                </div>
            </form>
        </main>
    </div>
    <script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#editor'))
            .then(editor => {
                editor.ui.view.editable.element.style.height = '400px';
            })
            .catch(error => {
                console.error(error);
            });
    </script>
</body>

</html>