<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Hair Niche Project Documentation</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            line-height: 1.6;
            color: #333;
        }

        h1 {
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
            margin-bottom: 20px;
            text-align: center;
        }

        h2 {
            color: #2980b9;
            margin-top: 30px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }

        h3 {
            color: #16a085;
            margin-top: 20px;
            margin-bottom: 10px;
        }

        h4 {
            color: #d35400;
            margin-top: 15px;
            margin-bottom: 5px;
        }

        p {
            margin-bottom: 10px;
            text-align: justify;
        }

        ul {
            margin-bottom: 15px;
        }

        li {
            margin-bottom: 5px;
        }

        .badge {
            background: #eee;
            padding: 2px 6px;
            border-radius: 4px;
            font-family: monospace;
            font-size: 0.9em;
        }

        .section {
            margin-bottom: 40px;
        }

        .toc {
            background: #f9f9f9;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 30px;
        }

        .toc h3 {
            margin-top: 0;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #eee;
            padding-top: 10px;
        }
    </style>
</head>

<body>
    <h1>Lugani Project Documentation</h1>

    <div class="toc">
        <h3>Table of Contents</h3>
        <ul>
            <li>1. <a href="#tech-stack">Technology Stack</a></li>
            <li>2. <a href="#roles">User Roles & Modules</a></li>
            <li>3. <a href="#features">Key Features & Highlights</a></li>
            <li>4. <a href="#installation">Installation & Setup</a></li>
            <li>5. <a href="#security">Security Measures</a></li>
        </ul>
    </div>

    <div class="section" id="intro">
        <h2>Overview</h2>
        <p>Lugani is a comprehensive E-commerce platform built with Laravel. It features a robust layout for standard
            users (shoppers), a dedicated panel for delivery agents, and a feature-rich admin dashboard for complete
            store management.</p>
    </div>

    <div class="section" id="tech-stack">
        <h2>1. Technology Stack</h2>
        <ul>
            <li><strong>Backend Framework</strong>: Laravel 12.x (PHP 8.2+)</li>
            <li><strong>Database</strong>: MySQL / SQLite (configurable)</li>
            <li><strong>Frontend</strong>: Blade Templating, Tailwind CSS, Vanilla JavaScript</li>
            <li><strong>Key Libraries</strong>:
                <ul>
                    <li><code>razorpay/razorpay</code>: Payment Gateway Integration</li>
                    <li><code>maatwebsite/excel</code>: Bulk Product Import</li>
                    <li><code>barryvdh/laravel-dompdf</code>: PDF Export (Invoices/Lists)</li>
                </ul>
            </li>
        </ul>
    </div>

    <div class="section" id="roles">
        <h2>2. User Roles & Modules</h2>

        <h3>A. Shop (Public Frontend)</h3>
        <p><strong>Target Audience</strong>: Customers/Visitors</p>
        <ul>
            <li><strong>Product Browsing</strong>: View products by Category and Subcategory. Product Search with
                Suggestions. Product Details: Description, variations (size/color), pricing, and images.</li>
            <li><strong>Cart & Checkout</strong>: Add to Cart, Update quantities, Remove items. Apply Coupons and Gift
                Cards. Secure Checkout Process (Address selection, Payment method).</li>
            <li><strong>Payment Options</strong>: Cash on Delivery (COD). Online Payment (Razorpay/PhonePe). Wallet
                Balance usage.</li>
            <li><strong>Static Pages</strong>: About Us, Contact Us, Policy Pages (Privacy, Shipping, Refund, etc.).
            </li>
            <li><strong>Blog & Testimonials</strong>: Read blogs and view customer testimonials.</li>
        </ul>

        <h3>B. User Dashboard (Authenticated Customers)</h3>
        <p><strong>Routes Prefix</strong>: <span class="badge">/user/*</span></p>
        <ul>
            <li><strong>Authentication</strong>: Login, Registration, Password Reset.</li>
            <li><strong>Profile Management</strong>: Update name, email, phone, and profile picture.</li>
            <li><strong>Address Book</strong>: Manage multiple delivery addresses (Add/Edit/Delete).</li>
            <li><strong>Order History</strong>: View past orders, order status, and download invoices.</li>
            <li><strong>Wallet System</strong>: View balance and transaction history.</li>
            <li><strong>Wishlist</strong>: Save products for later, move to cart.</li>
            <li><strong>Support</strong>: Tickets (Create and manage), Gift Cards (View purchased/received).</li>
        </ul>

        <h3>C. Delivery Agent Panel</h3>
        <p><strong>Routes Prefix</strong>: <span class="badge">/delivery/*</span></p>
        <ul>
            <li><strong>Dashboard</strong>: Overview of assigned, completed, and pending orders. Earnings statistics.
            </li>
            <li><strong>Order Management</strong>: View assigned orders with customer details. Update Order Status
                (e.g., Out for Delivery, Delivered).</li>
            <li><strong>Profile & KYC</strong>: Update personal details and profile photo. Manage Vehicles and Documents
                (License, ID Proof).</li>
            <li><strong>Notification</strong>: Receive system notifications.</li>
        </ul>

        <h3>D. Admin Panel</h3>
        <p><strong>Routes Prefix</strong>: <span class="badge">/admin/*</span></p>
        <p><strong>Security</strong>: Protected by Role-Based Access Control (RBAC).</p>

        <h4>1. Dashboard</h4>
        <ul>
            <li>Analytics overview: Total Sales, Orders, New Customers.</li>
            <li>Recent activity logs.</li>
        </ul>

        <h4>2. Product Management (`/admin/products`)</h4>
        <ul>
            <li><strong>CRUD Operations</strong>: Create, Read, Update, Delete products.</li>
            <li><strong>Variations</strong>: Manage sizes, colors, and stock levels.</li>
            <li><strong>Import/Export</strong>: Bulk Upload via Excel. Export Product List to PDF.</li>
            <li><strong>Categories</strong>: Manage Categories and Subcategories hierarchy.</li>
        </ul>

        <h4>3. Sales & Orders (`/admin/orders`)</h4>
        <ul>
            <li><strong>Order Listing</strong>: Filter by status, date, or search.</li>
            <li><strong>Order Details</strong>: View items, shipping info, and payment status.</li>
            <li><strong>Actions</strong>: Update Status, Assign Delivery Agents, Download Invoices.</li>
        </ul>

        <h4>4. User Management</h4>
        <ul>
            <li><strong>Clients</strong>: View registered customers, their orders, and wallet balance.</li>
            <li><strong>Administrators/Staff</strong>: Manage system users.</li>
            <li><strong>Roles & Permissions</strong>: Create dynamic roles (e.g., Manager, Editor). Assign granular
                permissions (e.g., `view_orders`, `create_products`).</li>
        </ul>

        <h4>5. Delivery Management (`/admin/delivery-agents`)</h4>
        <ul>
            <li><strong>Agents</strong>: List all agents, view profiles, and verify documents.</li>
            <li><strong>Vehicles</strong>: Monitor agent vehicles.</li>
            <li><strong>Notifications</strong>: Send custom notifications to agents.</li>
        </ul>

        <h4>6. Marketing</h4>
        <ul>
            <li><strong>Coupons & Discounts</strong>: Create percentage/fixed discount codes and automated discounts.
            </li>
            <li><strong>Promotional Banners</strong>: Manage homepage sliders.</li>
            <li><strong>Subscribers</strong>: View newsletter subscribers.</li>
        </ul>

        <h4>7. Content & Settings</h4>
        <ul>
            <li><strong>Content</strong>: Blogs, Testimonials, Support Tickets, Contact Inquiries.</li>
            <li><strong>Settings</strong>: Website (Logo, Name), Payment Gateways, Shipping Rules, SEO, Policies.</li>
        </ul>
    </div>

    <div class="page-break"></div>

    <div class="section" id="features">
        <h2>3. Key Features & Highlights</h2>
        <ul>
            <li><strong>Role-Based Access Control (RBAC)</strong>: Secure middleware ensures admins only access allowed
                resources.</li>
            <li><strong>Dynamic Menus</strong>: Mega Menu for categories on the frontend.</li>
            <li><strong>PDF Generation</strong>: Automated invoice and report generation.</li>
            <li><strong>Wallet System</strong>: Integrated wallet for refunds and loyalty.</li>
            <li><strong>Real-time Search</strong>: Search suggestions for products.</li>
        </ul>
    </div>

    <div class="section" id="installation">
        <h2>4. Installation & Setup</h2>
        <ol>
            <li><strong>Clone Repository</strong>: <code>git clone repo-url</code></li>
            <li><strong>Install Dependencies</strong>: <code>composer install && npm install</code></li>
            <li><strong>Environment Setup</strong>: Copy <code>.env.example</code> to <code>.env</code>. Configure DB
                credentials. Run <code>php artisan key:generate</code>.</li>
            <li><strong>Database</strong>: Run <code>php artisan migrate --seed</code> to setup DB and seed
                permissions/admin.</li>
            <li><strong>Run</strong>: <code>npm run build && php artisan serve</code></li>
        </ol>
    </div>

    <div class="section" id="security">
        <h2>5. Security Measures</h2>
        <ul>
            <li><strong>Middleware</strong>: <code>auth</code>, <code>admin</code>, <code>permission</code> checks.</li>
            <li><strong>CSRF Protection</strong>: Enabled on all forms.</li>
            <li><strong>Sanitization</strong>: Input validation on all controller methods.</li>
            <li><strong>Error Handling</strong>: Custom 403, 404, 500 Error Pages.</li>
        </ul>
    </div>

    <div class="footer">
        Generated on {{ date('Y-m-d H:i:s') }} | Lugani Project Documentation
    </div>
</body>

</html>