<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agent Details - Hair Niche Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Agent Details</h2>
            <div class="flex space-x-3">
                <a href="{{ route('admin.delivery-agents.edit', $deliveryAgent) }}"
                    class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm font-medium">Edit
                    Details</a>
                <a href="{{ route('admin.delivery-agents.index') }}"
                    class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium">Back to
                    List</a>
            </div>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto space-y-6">
                <!-- Header / Status -->
                <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100 flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        @if($deliveryAgent->user->profile_photo_path)
                            <img class="h-24 w-24 rounded-full object-cover border-4 border-gray-50"
                                src="{{ asset('storage/' . $deliveryAgent->user->profile_photo_path) }}?t={{ time() }}"
                                alt="">
                        @elseif($deliveryAgent->profile_image)
                            <img class="h-24 w-24 rounded-full object-cover border-4 border-gray-50"
                                src="{{ asset('storage/' . $deliveryAgent->profile_image) }}?t={{ time() }}" alt="">
                        @else
                            <div
                                class="h-24 w-24 rounded-full bg-gray-200 flex items-center justify-center text-gray-500 text-2xl font-bold border-4 border-gray-50">
                                {{ substr($deliveryAgent->user->name, 0, 1) }}
                            </div>
                        @endif
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">{{ $deliveryAgent->user->name }}</h1>
                            <p class="text-sm text-gray-500">Agent ID: #{{ $deliveryAgent->id }}</p>
                            <p class="text-sm text-gray-500 mt-1">Joined:
                                {{ $deliveryAgent->created_at->format('M d, Y') }}
                            </p>
                        </div>
                    </div>
                    <div>
                        <span
                            class="px-4 py-2 inline-flex text-sm leading-5 font-semibold rounded-full {{ $deliveryAgent->status ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ $deliveryAgent->status ? 'Active' : 'Inactive' }}
                        </span>
                    </div>
                </div>

                <!-- Financial Stats -->
                <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100 flex items-center justify-between">
                    <div>
                        <h3 class="text-sm font-medium text-gray-500 uppercase tracking-wider">Total Cash Collected
                            (COD)</h3>
                        <p class="mt-2 text-3xl font-extrabold text-gray-900">
                            ₹{{ number_format($cashCollected ?? 0, 2) }}</p>
                        <p class="text-sm text-gray-500">From {{ $codOrderCount ?? 0 }} Completed COD Orders</p>
                    </div>
                    <div class="p-3 bg-green-100 rounded-full">
                        <svg class="h-8 w-8 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Contact Info -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 pb-2 border-b">Contact Information</h3>
                        <dl class="space-y-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Email Address</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $deliveryAgent->user->email }}</dd>
                            </div>
                            <div class="col-span-1 md:col-span-2">
                                <dt class="text-sm font-medium text-gray-500">Device Token (FCM)</dt>
                                <dd
                                    class="mt-1 text-xs text-gray-500 font-mono break-all bg-gray-50 p-2 rounded border border-gray-200">
                                    {{ $deliveryAgent->user->fcm_token ?? 'Not Synced' }}
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Phone Number</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $deliveryAgent->phone }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Address</dt>
                                <dd class="mt-1 text-sm text-gray-900 whitespace-pre-line">{{ $deliveryAgent->address }}
                                </dd>
                            </div>
                            @if($deliveryAgent->alternate_phone)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Alternate Phone</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $deliveryAgent->alternate_phone }}</dd>
                                </div>
                            @endif
                            @if($deliveryAgent->dob)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Date of Birth</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $deliveryAgent->dob->format('M d, Y') }}</dd>
                                </div>
                            @endif
                            @if($deliveryAgent->gender)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Gender</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $deliveryAgent->gender }}</dd>
                                </div>
                            @endif
                            @if($deliveryAgent->father_name)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Father's Name</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $deliveryAgent->father_name }}</dd>
                                </div>
                            @endif
                            @if($deliveryAgent->spouse_name)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Spouse Name</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $deliveryAgent->spouse_name }}</dd>
                                </div>
                            @endif
                        </dl>
                    </div>

                    <!-- Vehicles Info -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 pb-2 border-b">Vehicles</h3>
                        <div class="space-y-4">
                            @forelse($deliveryAgent->vehicles as $vehicle)
                                <div class="bg-gray-50 p-3 rounded border">
                                    <div class="flex justify-between">
                                        <div>
                                            <p class="text-sm font-bold text-gray-900">{{ ucfirst($vehicle->type) }}</p>
                                            <p class="text-sm text-gray-700">{{ $vehicle->vehicle_number }}</p>
                                            <p class="text-xs text-gray-500">{{ $vehicle->model }}</p>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <p class="text-sm text-gray-500">No vehicles added.</p>
                            @endforelse
                        </div>
                    </div>

                    <!-- Bank Details -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 pb-2 border-b flex items-center">
                            <svg class="w-5 h-5 mr-2 text-indigo-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z">
                                </path>
                            </svg>
                            Bank Details
                        </h3>
                        @if($deliveryAgent->bank_name)
                            <dl class="space-y-4">
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Bank Name</dt>
                                    <dd class="mt-1 text-sm text-gray-900 font-semibold">{{ $deliveryAgent->bank_name }}
                                    </dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Account Number</dt>
                                    <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deliveryAgent->account_number }}
                                    </dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">IFSC Code</dt>
                                    <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deliveryAgent->ifsc_code }}</dd>
                                </div>
                            </dl>
                        @else
                            <div class="flex flex-col items-center justify-center py-6">
                                <svg class="w-12 h-12 text-gray-300 mb-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <p class="text-sm text-gray-500">Not provided yet</p>
                            </div>
                        @endif
                    </div>

                    <!-- KYC Documents -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100 md:col-span-2">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 pb-2 border-b">Documents & KYC</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            @forelse($deliveryAgent->documents as $doc)
                                <div class="bg-gray-50 rounded-lg p-4 border flex flex-col items-center text-center">
                                    <h4 class="font-medium text-gray-900">{{ $doc->type }}</h4>
                                    <p class="text-sm text-gray-600 mb-3">{{ $doc->number }}</p>
                                    <a href="{{ Storage::disk('public')->url($doc->image_path) }}" target="_blank"
                                        class="block w-full h-32 bg-gray-200 rounded overflow-hidden relative group">
                                        <img src="{{ Storage::disk('public')->url($doc->image_path) }}"
                                            class="w-full h-full object-cover">
                                        <div
                                            class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-10 transition-all">
                                        </div>
                                    </a>
                                </div>
                            @empty
                                <div class="col-span-3 text-center text-sm text-gray-500">No documents uploaded.</div>
                            @endforelse
                        </div>
                    </div>
                </div>

                <!-- Latest Ratings & Reviews -->
                <div id="ratings" class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-100 flex items-center justify-between bg-amber-50/30">
                        <h3 class="text-lg font-bold text-gray-900 flex items-center">
                            <svg class="h-5 w-5 mr-2 text-amber-500 fill-current" viewBox="0 0 20 20">
                                <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                            </svg>
                            Performance Ratings & Feedback
                        </h3>
                        <div class="flex items-center">
                            <span
                                class="text-2xl font-black text-amber-600 mr-2">{{ number_format($deliveryAgent->average_rating, 1) }}</span>
                            <div class="flex">
                                @for($i = 1; $i <= 5; $i++)
                                    <svg class="w-4 h-4 {{ $i <= round($deliveryAgent->average_rating) ? 'text-amber-400 fill-current' : 'text-gray-200 fill-current' }}"
                                        viewBox="0 0 20 20">
                                        <path
                                            d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                    </svg>
                                @endfor
                            </div>
                        </div>
                    </div>
                    <div class="divide-y divide-gray-100">
                        @forelse($deliveryAgent->ratings as $rating)
                            <div class="p-6 hover:bg-gray-50 transition-colors">
                                <div class="flex justify-between items-start mb-2">
                                    <div class="flex items-center">
                                        <div
                                            class="h-8 w-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-500 text-xs font-bold mr-3 border border-gray-200">
                                            {{ substr($rating->user->name ?? 'U', 0, 1) }}
                                        </div>
                                        <div>
                                            <p class="text-sm font-bold text-gray-900">
                                                {{ $rating->user->name ?? 'Anonymous Customer' }}
                                            </p>
                                            <p class="text-[10px] text-gray-500 uppercase font-medium tracking-wider">Order
                                                #{{ $rating->order->order_number ?? 'N/A' }} •
                                                {{ $rating->created_at->format('M d, Y h:i A') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="flex">
                                        @for($i = 1; $i <= 5; $i++)
                                            <svg class="w-3.5 h-3.5 {{ $i <= $rating->rating ? 'text-amber-400 fill-current' : 'text-gray-200 fill-current' }}"
                                                viewBox="0 0 20 20">
                                                <path
                                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                            </svg>
                                        @endfor
                                    </div>
                                </div>
                                @if($rating->comment)
                                    <p
                                        class="text-sm text-gray-700 italic mt-3 bg-gray-50 p-3 rounded-lg border border-gray-100">
                                        "{{ $rating->comment }}"</p>
                                @endif
                            </div>
                        @empty
                            <div class="p-10 text-center text-gray-500 italic">
                                <p>No ratings or performance reviews submitted for this agent yet.</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>

</html>