<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Send Notification - Hair Niche Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        [x-cloak] {
            display: none !important;
        }
    </style>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Send Notification</h2>
            <a href="{{ route('admin.delivery-agents.index') }}"
                class="bg-white border border-gray-300 hover:bg-gray-50 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium shadow-sm transition-colors">
                Back to List
            </a>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-2xl mx-auto">
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="p-6 border-b border-gray-100 bg-gray-50/50">
                        <h3 class="text-lg font-medium text-gray-900">Compose Message</h3>
                        <p class="mt-1 text-sm text-gray-500">Send a notification to delivery agents apps.</p>
                    </div>

                    <form action="{{ route('admin.delivery-agents.send-notification') }}" method="POST"
                        class="p-6 space-y-6">
                        @csrf

                        <!-- Searchable Dropdown -->
                        <div x-data="{
                            open: false,
                            search: '',
                            selectedId: 'all',
                            selectedName: 'All Delivery Agents',
                            options: [
                                { id: 'all', name: 'All Delivery Agents', phone: '' },
                                @foreach($agents as $agent)
                                    { id: '{{ $agent->id }}', name: '{{ addslashes($agent->user->name) }}', phone: '{{ $agent->phone }}' },
                                @endforeach
                            ],
                            get filteredOptions() {
                                if (this.search === '') return this.options;
                                return this.options.filter(option => 
                                    option.name.toLowerCase().includes(this.search.toLowerCase()) || 
                                    option.phone.includes(this.search)
                                );
                            },
                            select(option) {
                                this.selectedId = option.id;
                                this.selectedName = option.name + (option.phone ? ' (' + option.phone + ')' : '');
                                this.open = false;
                                this.search = '';
                            }
                        }" class="relative">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Recipient</label>
                            <input type="hidden" name="agent_id" :value="selectedId">

                            <div class="relative">
                                <button type="button" @click="open = !open"
                                    class="relative w-full bg-white border border-gray-300 rounded-lg shadow-sm pl-3 pr-10 py-2.5 text-left cursor-default focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                    <span class="block truncate" x-text="selectedName"></span>
                                    <span class="absolute inset-y-0 right-0 flex items-center pr-2 pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                            viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                            <path fill-rule="evenodd"
                                                d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </span>
                                </button>

                                <div x-show="open" @click.away="open = false" x-cloak
                                    class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md py-1 text-base ring-1 ring-black ring-opacity-5 overflow-auto focus:outline-none sm:text-sm">

                                    <div class="px-3 py-2 sticky top-0 bg-white border-b border-gray-100">
                                        <input type="text" x-model="search" placeholder="Search agents..."
                                            class="w-full border-gray-300 rounded-md text-sm focus:ring-blue-500 focus:border-blue-500 p-2">
                                    </div>

                                    <template x-for="option in filteredOptions" :key="option.id">
                                        <div @click="select(option)"
                                            class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-blue-50 transition-colors"
                                            :class="{'bg-blue-50 text-blue-900': selectedId === option.id, 'text-gray-900': selectedId !== option.id}">
                                            <div class="flex items-center">
                                                <span class="font-normal block truncate"
                                                    :class="{'font-semibold': selectedId === option.id}"
                                                    x-text="option.name"></span>
                                                <span x-show="option.phone" class="ml-2 text-gray-500 text-xs"
                                                    x-text="'(' + option.phone + ')'"></span>
                                            </div>

                                            <span x-show="selectedId === option.id"
                                                class="text-blue-600 absolute inset-y-0 right-0 flex items-center pr-4">
                                                <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            </span>
                                        </div>
                                    </template>
                                    <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-gray-500 text-sm">
                                        No agents found.
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Subject</label>
                            <input type="text" name="title" required
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm py-2.5"
                                placeholder="Brief title for the notification">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Message Content</label>
                            <div class="mt-1">
                                <textarea name="message" rows="5" required
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                    placeholder="Type your message here..."></textarea>
                            </div>
                            <p class="mt-2 text-sm text-gray-500">This message will be sent to the agent's dashboard
                                immediately.</p>
                        </div>

                        <div class="pt-4 border-t border-gray-100 flex justify-end">
                            <button type="submit"
                                class="inline-flex justify-center py-2.5 px-6 border border-transparent shadow-sm text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors">
                                Send Notification
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>