<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Delivery Agent - Hair Niche Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Edit Delivery Agent</h2>
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.delivery-agents.index') }}"
                    class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors">
                    <svg class="-ml-1 mr-2 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                    Back to List
                </a>
            </div>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">

                @if($errors->any())
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg text-red-700">
                        <ul class="list-disc list-inside">
                            @foreach($errors->all() as $error) <li>{{ $error }}</li> @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('admin.delivery-agents.update', $deliveryAgent) }}" method="POST"
                    enctype="multipart/form-data" class="space-y-8" x-data="{
                        documents: [],
                        vehicles: [],
                        addDocument() { this.documents.push({id: Date.now(), type: '', number: ''}); },
                        removeDocument(index) { this.documents.splice(index, 1); },
                        addVehicle() { this.vehicles.push({id: Date.now(), type: '', vehicle_number: '', model: ''}); },
                        removeVehicle(index) { this.vehicles.splice(index, 1); }
                    }">
                    @csrf
                    @method('PUT')

                    <!-- Login Credentials -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Login Credentials</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Full Name</label>
                                <input type="text" name="name" value="{{ old('name', $deliveryAgent->user->name) }}"
                                    required
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Email Address</label>
                                <input type="email" name="email" value="{{ old('email', $deliveryAgent->user->email) }}"
                                    required
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div class="md:col-span-2" x-data="{ show: false }">
                                <label class="block text-sm font-medium text-gray-700 mb-1">New Password (leave blank to
                                    keep current)</label>
                                <div class="relative">
                                    <input :type="show ? 'text' : 'password'" name="password"
                                        class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2 pr-10">
                                    <button type="button" @click="show = !show"
                                        class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none">
                                        <svg x-show="!show" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                        <svg x-show="show" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor" style="display:none;">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Personal Information -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Profile Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Profile Picture</label>
                                @if($deliveryAgent->user->profile_photo_path)
                                    <div class="mb-2">
                                        <img src="{{ asset('storage/' . $deliveryAgent->user->profile_photo_path) }}?t={{ time() }}"
                                            alt="Profile" class="h-20 w-20 rounded-full object-cover">
                                    </div>
                                @elseif($deliveryAgent->profile_image)
                                    <div class="mb-2">
                                        <img src="{{ asset('storage/' . $deliveryAgent->profile_image) }}?t={{ time() }}"
                                            alt="Profile" class="h-20 w-20 rounded-full object-cover">
                                    </div>
                                @endif
                                <input type="file" name="profile_image"
                                    class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Phone Number</label>
                                <input type="text" name="phone" value="{{ old('phone', $deliveryAgent->phone) }}"
                                    required
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Alternate Phone
                                    (Optional)</label>
                                <input type="text" name="alternate_phone"
                                    value="{{ old('alternate_phone', $deliveryAgent->alternate_phone) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Date of Birth</label>
                                <input type="date" name="dob"
                                    value="{{ old('dob', $deliveryAgent->dob ? $deliveryAgent->dob->format('Y-m-d') : '') }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Gender</label>
                                <select name="gender"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                    <option value="">Select Gender</option>
                                    <option value="Male" {{ $deliveryAgent->gender == 'Male' ? 'selected' : '' }}>Male
                                    </option>
                                    <option value="Female" {{ $deliveryAgent->gender == 'Female' ? 'selected' : '' }}>
                                        Female</option>
                                    <option value="Other" {{ $deliveryAgent->gender == 'Other' ? 'selected' : '' }}>Other
                                    </option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Father's Name</label>
                                <input type="text" name="father_name"
                                    value="{{ old('father_name', $deliveryAgent->father_name) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Spouse Name (Optional)</label>
                                <input type="text" name="spouse_name"
                                    value="{{ old('spouse_name', $deliveryAgent->spouse_name) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700">Full Address</label>
                                <textarea name="address" rows="3" required
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">{{ old('address', $deliveryAgent->address) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Documents (Existing & New) -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center justify-between mb-4 border-b pb-2">
                            <h3 class="text-lg font-medium text-gray-900">Documents & KYC</h3>
                            <button type="button" @click="addDocument()"
                                class="text-sm bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">+ Add New
                                Document</button>
                        </div>

                        <!-- Existing Documents -->
                        @if($deliveryAgent->documents->count() > 0)
                            <div class="space-y-4 mb-6">
                                <p class="text-xs font-semibold text-gray-500 uppercase">Existing Documents</p>
                                @foreach($deliveryAgent->documents as $doc)
                                    <div
                                        class="grid grid-cols-1 md:grid-cols-12 gap-4 p-4 border rounded-lg bg-gray-50 relative items-end">
                                        <div class="md:col-span-3">
                                            <a href="{{ Storage::disk('public')->url($doc->image_path) }}" target="_blank"
                                                class="block mb-2">
                                                <img src="{{ Storage::disk('public')->url($doc->image_path) }}?t={{ time() }}"
                                                    class="h-20 w-auto object-cover rounded border">
                                            </a>
                                            <input type="file" name="existing_documents[{{ $doc->id }}][image]"
                                                class="text-xs w-full">
                                        </div>
                                        <div class="md:col-span-3">
                                            <label class="block text-xs font-medium text-gray-700">Type</label>
                                            <select name="existing_documents[{{ $doc->id }}][type]"
                                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm p-2">
                                                <option value="Aadhar Card" {{ $doc->type == 'Aadhar Card' ? 'selected' : '' }}>
                                                    Aadhar Card</option>
                                                <option value="Voter ID" {{ $doc->type == 'Voter ID' ? 'selected' : '' }}>Voter ID
                                                </option>
                                                <option value="Driving License" {{ $doc->type == 'Driving License' ? 'selected' : '' }}>Driving License</option>
                                                <option value="PAN Card" {{ $doc->type == 'PAN Card' ? 'selected' : '' }}>PAN Card
                                                </option>
                                                <option value="Other" {{ $doc->type == 'Other' ? 'selected' : '' }}>Other</option>
                                            </select>
                                        </div>
                                        <div class="md:col-span-4">
                                            <label class="block text-xs font-medium text-gray-700">Number</label>
                                            <input type="text" name="existing_documents[{{ $doc->id }}][number]"
                                                value="{{ $doc->number }}"
                                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm p-2">
                                        </div>
                                        <div class="md:col-span-2 text-right">
                                            <button type="button"
                                                onclick="deleteItem('{{ route('admin.delivery-agents.delete-document', $doc->id) }}')"
                                                class="text-red-600 hover:text-red-800 text-sm font-medium">
                                                Delete
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <!-- New Documents Form -->
                        <template x-for="(doc, index) in documents" :key="doc.id">
                            <div
                                class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4 p-4 border rounded-lg bg-blue-50 relative border-blue-100">
                                <button type="button" @click="removeDocument(index)"
                                    class="absolute top-2 right-2 text-red-500 hover:text-red-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </button>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Type</label>
                                    <select :name="'documents['+index+'][type]'" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                        <option value="">Select Type</option>
                                        <option value="Aadhar Card">Aadhar Card</option>
                                        <option value="Voter ID">Voter ID</option>
                                        <option value="Driving License">Driving License</option>
                                        <option value="PAN Card">PAN Card</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Number</label>
                                    <input type="text" :name="'documents['+index+'][number]'" placeholder="ID Number"
                                        required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Image</label>
                                    <input type="file" :name="'documents['+index+'][image]'" required
                                        class="mt-1 block w-full text-sm text-gray-500 file:mr-2 file:py-1 file:px-3 file:rounded-full file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                </div>
                            </div>
                        </template>
                    </div>

                    <!-- Vehicles (Existing & New) -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center justify-between mb-4 border-b pb-2">
                            <h3 class="text-lg font-medium text-gray-900">Vehicles</h3>
                            <button type="button" @click="addVehicle()"
                                class="text-sm bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">+ Add New
                                Vehicle</button>
                        </div>

                        <!-- Existing Vehicles -->
                        @if($deliveryAgent->vehicles->count() > 0)
                            <div class="space-y-4 mb-6">
                                <p class="text-xs font-semibold text-gray-500 uppercase">Existing Vehicles</p>
                                @foreach($deliveryAgent->vehicles as $v)
                                    <div
                                        class="grid grid-cols-1 md:grid-cols-12 gap-4 p-4 border rounded-lg bg-gray-50 relative items-end">
                                        <div class="md:col-span-3">
                                            <label class="block text-xs font-medium text-gray-700">Type</label>
                                            <select name="existing_vehicles[{{ $v->id }}][type]"
                                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm p-2">
                                                <option value="Bike" {{ $v->type == 'Bike' ? 'selected' : '' }}>Bike</option>
                                                <option value="Scooter" {{ $v->type == 'Scooter' ? 'selected' : '' }}>Scooter
                                                </option>
                                                <option value="Van" {{ $v->type == 'Van' ? 'selected' : '' }}>Van</option>
                                                <option value="Truck" {{ $v->type == 'Truck' ? 'selected' : '' }}>Truck</option>
                                                <option value="Other" {{ $v->type == 'Other' ? 'selected' : '' }}>Other</option>
                                            </select>
                                        </div>
                                        <div class="md:col-span-4">
                                            <label class="block text-xs font-medium text-gray-700">Number</label>
                                            <input type="text" name="existing_vehicles[{{ $v->id }}][vehicle_number]"
                                                value="{{ $v->vehicle_number }}"
                                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm p-2">
                                        </div>
                                        <div class="md:col-span-3">
                                            <label class="block text-xs font-medium text-gray-700">Model</label>
                                            <input type="text" name="existing_vehicles[{{ $v->id }}][model]"
                                                value="{{ $v->model }}"
                                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm p-2">
                                        </div>
                                        <div class="md:col-span-2 text-right">
                                            <button type="button"
                                                onclick="deleteItem('{{ route('admin.delivery-agents.delete-vehicle', $v->id) }}')"
                                                class="text-red-600 hover:text-red-800 text-sm font-medium">
                                                Delete
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <template x-for="(vehicle, index) in vehicles" :key="vehicle.id">
                            <div
                                class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4 p-4 border rounded-lg bg-blue-50 relative border-blue-100">
                                <button type="button" @click="removeVehicle(index)"
                                    class="absolute top-2 right-2 text-red-500 hover:text-red-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </button>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Type</label>
                                    <select :name="'vehicles['+index+'][type]'" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                        <option value="">Select Type</option>
                                        <option value="Bike">Bike</option>
                                        <option value="Scooter">Scooter</option>
                                        <option value="Van">Van</option>
                                        <option value="Truck">Truck</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Vehicle Number</label>
                                    <input type="text" :name="'vehicles['+index+'][vehicle_number]'"
                                        placeholder="XX-00-XX-0000" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Model</label>
                                    <input type="text" :name="'vehicles['+index+'][model]'"
                                        placeholder="e.g. Honda Activa"
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                </div>
                            </div>
                        </template>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100 flex items-center">
                        <input id="status" name="status" type="checkbox" value="1" {{ $deliveryAgent->status ? 'checked' : '' }} class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="status" class="ml-2 block text-sm text-gray-900">
                            Active Status
                        </label>
                    </div>

                    <div class="flex justify-end gap-3 pt-4">
                        <a href="{{ route('admin.delivery-agents.index') }}"
                            class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Cancel
                        </a>
                        <button type="submit"
                            class="px-6 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Update Agent
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
    <script>
        function deleteItem(url) {
            if (confirm('Are you sure you want to delete this item?')) {
                fetch(url, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Content-Type': 'application/json'
                    }
                }).then(response => {
                    if (response.ok) {
                        location.reload();
                    } else {
                        alert('Error deleting item');
                    }
                });
            }
        }
    </script>
</body>

</html>