<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Hair Niche By Shelly Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Outfit', 'Inter', sans-serif;
        }
    </style>
    @include('admin.partials.styles')
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <!-- Professional Header -->
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <div>
                <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">System Overview</h2>
            </div>
            <div class="flex items-center gap-6">
                <!-- Visit Site -->
                <a href="{{ url('/') }}" target="_blank"
                    class="hidden md:flex items-center gap-2 px-3 py-2 bg-slate-50 text-slate-600 rounded-lg hover:bg-blue-50 hover:text-blue-600 transition-all group">
                    <svg class="w-4 h-4 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                    </svg>
                    <span class="text-xs font-bold uppercase tracking-wider">Visit Site</span>
                </a>

                <!-- Support Tickets -->
                <a href="{{ route('admin.tickets.index') }}"
                    class="relative p-2 text-slate-400 hover:text-blue-600 transition-all tooltip" title="Support Tickets">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                    </svg>
                    @php
                        $openTicketsCount = \App\Models\Ticket::where('status', 'open')->count();
                    @endphp
                    @if($openTicketsCount > 0)
                         <span class="absolute top-0 right-0 inline-flex items-center justify-center px-1.5 py-0.5 text-xs font-bold leading-none text-white transform translate-x-1/4 -translate-y-1/4 bg-red-600 rounded-full">{{ $openTicketsCount }}</span>
                    @endif
                </a>

                <!-- Notifications -->
                <a href="{{ route('admin.notifications.index') }}"
                    class="relative p-2 text-slate-400 hover:text-blue-600 transition-all tooltip" title="Notifications">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                    </svg>
                    @php $unreadCount = auth()->user()->unreadNotifications->count(); @endphp
                    @if($unreadCount > 0)
                        <span class="absolute top-0 right-0 inline-flex items-center justify-center px-1.5 py-0.5 text-xs font-bold leading-none text-white transform translate-x-1/4 -translate-y-1/4 bg-red-600 rounded-full">{{ $unreadCount }}</span>
                    @endif
                </a>

                <!-- Profile -->
                <div class="flex items-center gap-3 pl-6">
                    <div class="text-right hidden sm:block">
                        <p class="text-sm font-extrabold text-[#0f172a]">{{ auth()->user()->name }}</p>
                        <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest">Master Admin</p>
                    </div>
                    <div
                        class="h-9 w-9 rounded-full bg-blue-600 flex items-center justify-center font-bold text-white shadow-lg shadow-blue-100">
                        {{ substr(auth()->user()->name, 0, 1) }}
                    </div>
                </div>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-white p-8">
            <!-- Stats -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
                <!-- Categories -->
                <div
                    class="bg-white rounded-2xl p-6 border border-slate-100 shadow-sm hover:shadow-xl hover:shadow-blue-500/5 transition-all group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="bg-blue-50 p-2.5 rounded-xl text-blue-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                            </svg>
                        </div>
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Inventory</span>
                    </div>
                    <h3 class="text-3xl font-extrabold text-[#0f172a] mb-0.5 tracking-tight">
                        {{ $counts['categories'] ?? 0 }}
                    </h3>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Product Categories</p>
                </div>

                <!-- Products -->
                <div
                    class="bg-white rounded-2xl p-6 border border-slate-100 shadow-sm hover:shadow-xl hover:shadow-blue-500/5 transition-all group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="bg-indigo-50 p-2.5 rounded-xl text-indigo-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                            </svg>
                        </div>
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Catalog</span>
                    </div>
                    <h3 class="text-3xl font-extrabold text-[#0f172a] mb-0.5 tracking-tight">
                        {{ $counts['products'] ?? 0 }}
                    </h3>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Listed Products</p>
                </div>

                <!-- Customers -->
                <div
                    class="bg-white rounded-2xl p-6 border border-slate-100 shadow-sm hover:shadow-xl hover:shadow-blue-500/5 transition-all group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="bg-emerald-50 p-2.5 rounded-xl text-emerald-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                        </div>
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Network</span>
                    </div>
                    <h3 class="text-3xl font-extrabold text-[#0f172a] mb-0.5 tracking-tight">
                        {{ $counts['clients'] ?? 0 }}
                    </h3>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Active Clients</p>
                </div>

                <!-- Revenue -->
                <div
                    class="bg-white rounded-2xl p-6 border border-slate-100 shadow-sm hover:shadow-xl hover:shadow-blue-500/5 transition-all group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="bg-amber-50 p-2.5 rounded-xl text-amber-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Finance</span>
                    </div>
                    <h3 class="text-3xl font-extrabold text-[#0f172a] mb-0.5 tracking-tight">
                        ₹{{ number_format($counts['total_revenue'] ?? 0, 0) }}</h3>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Gross Revenue</p>
                </div>
            </div>

            <!-- Orders Analysis -->
            <div class="mb-12">
                <div class="mb-6 flex items-center justify-between">
                    <div>
                        <h2 class="text-xl font-extrabold text-[#0f172a] uppercase tracking-tight italic">Order Pipeline
                        </h2>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Real-time status
                            tracking</p>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6">
                    @php
                        $statuses = [
                            ['label' => 'Pending', 'key' => 'pending_orders', 'color' => 'amber'],
                            ['label' => 'Processing', 'key' => 'processed_orders', 'color' => 'blue'],
                            ['label' => 'Shipped', 'key' => 'shipped_orders', 'color' => 'purple'],
                            ['label' => 'Completed', 'key' => 'completed_orders', 'color' => 'emerald'],
                        ];
                    @endphp
                    @foreach($statuses as $status)
                        <div
                            class="bg-white p-8 rounded-3xl border border-slate-100 shadow-sm flex items-center justify-between group hover:border-{{ $status['color'] }}-200 transition-all">
                            <div>
                                <span
                                    class="text-[10px] font-black text-{{ $status['color'] }}-600 uppercase tracking-[0.2em] block mb-3">{{ $status['label'] }}</span>
                                <h4 class="text-4xl font-extrabold text-[#0f172a] tracking-tighter">
                                    {{ $counts[$status['key']] ?? 0 }}
                                </h4>
                            </div>
                            <div
                                class="w-16 h-16 rounded-2xl bg-{{ $status['color'] }}-50 flex items-center justify-center text-{{ $status['color'] }}-500 group-hover:scale-110 transition-transform">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                                </svg>
                            </div>
                        </div>
                    @endforeach
                    <div
                        class="bg-white p-8 rounded-3xl border border-slate-100 shadow-sm flex items-center justify-between group">
                        <div>
                            <span
                                class="text-[10px] font-black text-red-600 uppercase tracking-[0.2em] block mb-3">Cancelled</span>
                            <h4 class="text-4xl font-extrabold text-[#0f172a] tracking-tighter">
                                {{ $counts['cancelled_orders'] ?? 0 }}
                            </h4>
                        </div>
                        <div class="w-16 h-16 rounded-2xl bg-red-50 flex items-center justify-center text-red-500">
                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </div>
                    </div>

                    <div
                        class="bg-white p-8 rounded-3xl border border-slate-100 shadow-sm flex items-center justify-between group">
                        <div>
                            <span
                                class="text-[10px] font-black text-indigo-600 uppercase tracking-[0.2em] block mb-3">Returned</span>
                            <h4 class="text-4xl font-extrabold text-[#0f172a] tracking-tighter">
                                {{ $counts['returned_orders'] ?? 0 }}
                            </h4>
                        </div>
                        <div class="w-16 h-16 rounded-2xl bg-indigo-50 flex items-center justify-center text-indigo-500">
                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tables -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-10">
                <!-- Recent Orders -->
                <div
                    class="bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 overflow-hidden">
                    <div class="p-8 border-b border-slate-50 flex justify-between items-center">
                        <h3 class="text-base font-black text-[#0f172a] uppercase tracking-tighter italic">Live
                            Transactions</h3>
                        <a href="{{ route('admin.orders.index') }}"
                            class="text-[10px] font-black text-blue-600 uppercase tracking-widest hover:text-blue-700">View
                            History &rarr;</a>
                    </div>
                    <div class="overflow-x-auto px-4 pb-4">
                        <table class="w-full">
                            <thead class="bg-slate-50/50">
                                <tr class="text-[9px] font-black text-slate-400 uppercase tracking-widest">
                                    <th class="px-6 py-4 text-left">Reference</th>
                                    <th class="px-6 py-4 text-left">Client</th>
                                    <th class="px-6 py-4 text-left">Total</th>
                                    <th class="px-6 py-4 text-left">Status</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-50">
                                @forelse($recentOrders as $order)
                                                                <tr class="hover:bg-slate-50/50 transition-colors">
                                                                    <td class="px-6 py-5 text-xs font-extrabold text-[#0f172a] tracking-tight">
                                                                        #{{ $order->order_number }}</td>
                                                                    <td class="px-6 py-5">
                                                                        <div
                                                                            class="text-[11px] font-extrabold text-[#0f172a] uppercase tracking-tighter">
                                                                            {{ $order->user ? $order->user->name : ($order->name ?? 'Guest User') }}
                                                                        </div>
                                                                        <div class="text-[9px] text-slate-400 font-bold uppercase tracking-widest">
                                                                            {{ $order->created_at->diffForHumans() }}
                                                                        </div>
                                                                    </td>
                                                                    <td class="px-6 py-5 text-xs font-extrabold text-[#0f172a]">
                                                                        ₹{{ number_format($order->total, 2) }}</td>
                                                                    <td class="px-6 py-5">
                                                                        <span class="px-3 py-1.5 rounded-lg text-[9px] font-black uppercase tracking-widest shadow-sm {{ match ($order->status) {
                                        'completed' => 'bg-emerald-50 text-emerald-600 border border-emerald-100',
                                        'cancelled' => 'bg-red-50 text-red-600 border border-red-100',
                                        'pending' => 'bg-amber-50 text-amber-600 border border-amber-100',
                                        default => 'bg-blue-50 text-blue-600 border border-blue-100'
                                    } }} shadow-sm shadow-blue-50/50">{{ $order->status }}</span>
                                                                    </td>
                                                                </tr>
                                @empty
                                    <tr>
                                        <td colspan="4"
                                            class="px-6 py-16 text-center text-[10px] font-bold text-slate-400 uppercase tracking-widest italic">
                                            No transactions recorded yet.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Stock Alerts -->
                <div
                    class="bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 overflow-hidden">
                    <div class="p-8 border-b border-slate-50 flex justify-between items-center">
                        <h3 class="text-base font-black text-[#0f172a] uppercase tracking-tighter italic">Critical Stock
                        </h3>
                        <a href="{{ route('admin.products.index') }}"
                            class="text-[10px] font-black text-red-500 uppercase tracking-widest hover:text-red-600">Inventory
                            Feed &rarr;</a>
                    </div>
                    <div class="overflow-x-auto px-4 pb-4">
                        <table class="w-full">
                            <thead class="bg-slate-50/50">
                                <tr class="text-[9px] font-black text-slate-400 uppercase tracking-widest">
                                    <th class="px-6 py-4 text-left">Product Detail</th>
                                    <th class="px-6 py-4 text-left">Level</th>
                                    <th class="px-6 py-4 text-right">Action</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-50">
                                @forelse($lowStockItems ?? [] as $item)
                                    <tr class="hover:bg-slate-50/50 transition-colors">
                                        <td class="px-6 py-5">
                                            <div
                                                class="text-[11px] font-extrabold text-[#0f172a] uppercase tracking-tighter">
                                                {{ $item->product?->name ?? 'Syncing Product...' }}
                                            </div>
                                            @if($item->sku)
                                                <div class="text-[9px] font-mono text-slate-400 uppercase tracking-widest">UID:
                                                    {{ $item->sku }}
                                            </div> @endif
                                        </td>
                                        <td class="px-6 py-5">
                                            <span
                                                class="inline-flex items-center px-2 py-1.5 rounded-lg text-[9px] font-black bg-red-50 text-red-600 border border-red-100 uppercase tracking-tighter shadow-sm shadow-red-50">{{ $item->stock }}
                                                remaining</span>
                                        </td>
                                        <td class="px-6 py-5 text-right">
                                            <a href="{{ route('admin.products.edit', $item->product_id) }}"
                                                class="text-[10px] font-black text-blue-600 hover:text-blue-700 uppercase tracking-widest underline decoration-2 underline-offset-4">Refill</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3"
                                            class="px-6 py-16 text-center text-[10px] font-bold text-slate-400 uppercase tracking-widest italic">
                                            All systems are operational.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Ratings & Performance Analysis -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-10">
                <!-- Recent Driver Ratings -->
                <div
                    class="bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 overflow-hidden">
                    <div class="p-8 border-b border-slate-50 flex justify-between items-center bg-amber-50/10">
                        <div class="flex items-center gap-3">
                            <div class="bg-amber-100 p-2 rounded-xl text-amber-600">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                </svg>
                            </div>
                            <h3 class="text-base font-black text-[#0f172a] uppercase tracking-tighter italic">Fleet
                                Performance</h3>
                        </div>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-slate-50/50">
                                <tr class="text-[9px] font-black text-slate-400 uppercase tracking-widest">
                                    <th class="px-6 py-4 text-left">Driver</th>
                                    <th class="px-6 py-4 text-left">Rating</th>
                                    <th class="px-6 py-4 text-left">Feedback</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-50">
                                @forelse($recentDriverRatings as $rating)
                                    <tr class="hover:bg-slate-50/50 transition-colors">
                                        <td class="px-6 py-5">
                                            <div
                                                class="text-[11px] font-extrabold text-[#0f172a] uppercase tracking-tighter">
                                                {{ $rating->deliveryAgent->user->name ?? 'System User' }}</div>
                                            <div class="text-[9px] text-slate-400 font-bold uppercase tracking-widest">via
                                                Order #{{ $rating->order->order_number ?? 'N/A' }}</div>
                                        </td>
                                        <td class="px-6 py-5">
                                            <div class="flex items-center gap-1">
                                                <span
                                                    class="text-xs font-black text-amber-600">{{ number_format($rating->rating, 1) }}</span>
                                                <svg class="w-3 h-3 text-amber-400 fill-current" viewBox="0 0 20 20">
                                                    <path
                                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                </svg>
                                            </div>
                                        </td>
                                        <td class="px-6 py-5">
                                            <p
                                                class="text-[10px] text-slate-500 font-medium line-clamp-1 italic max-w-[150px]">
                                                "{{ $rating->comment ?? 'No comment' }}"</p>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3"
                                            class="px-6 py-10 text-center text-[10px] font-bold text-slate-400 uppercase tracking-widest italic">
                                            No fleet feedback yet.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Recent Item Ratings -->
                <div
                    class="bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 overflow-hidden">
                    <div class="p-8 border-b border-slate-50 flex justify-between items-center bg-indigo-50/10">
                        <div class="flex items-center gap-3">
                            <div class="bg-indigo-100 p-2 rounded-xl text-indigo-600">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                </svg>
                            </div>
                            <h3 class="text-base font-black text-[#0f172a] uppercase tracking-tighter italic">Product
                                Reviews</h3>
                        </div>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-slate-50/50">
                                <tr class="text-[9px] font-black text-slate-400 uppercase tracking-widest">
                                    <th class="px-6 py-4 text-left">Product</th>
                                    <th class="px-6 py-4 text-left">Rating</th>
                                    <th class="px-6 py-4 text-left">Customer</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-50">
                                @forelse($recentItemRatings as $review)
                                    <tr class="hover:bg-slate-50/50 transition-colors">
                                        <td class="px-6 py-5">
                                            <div
                                                class="text-[11px] font-extrabold text-[#0f172a] uppercase tracking-tighter truncate max-w-[120px]">
                                                {{ $review->product->name ?? 'Unknown Product' }}</div>
                                            <div class="text-[9px] text-slate-400 font-bold uppercase tracking-widest">
                                                {{ $review->created_at->diffForHumans() }}</div>
                                        </td>
                                        <td class="px-6 py-5">
                                            <div class="flex items-center gap-1">
                                                <span
                                                    class="text-xs font-black text-indigo-600">{{ number_format($review->rating, 1) }}</span>
                                                <svg class="w-3 h-3 text-emerald-400 fill-current" viewBox="0 0 20 20">
                                                    <path
                                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                </svg>
                                            </div>
                                        </td>
                                        <td class="px-6 py-5">
                                            <div
                                                class="text-[10px] text-slate-900 font-extrabold uppercase tracking-tighter">
                                                {{ $review->user->name ?? 'Guest' }}</div>
                                            <p
                                                class="text-[9px] text-slate-400 font-medium line-clamp-1 italic max-w-[100px]">
                                                "{{ $review->review ?? 'No comment' }}"</p>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3"
                                            class="px-6 py-10 text-center text-[10px] font-bold text-slate-400 uppercase tracking-widest italic">
                                            No reviews yet.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>

</html>