<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video Consultations - Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Outfit', 'Inter', sans-serif;
        }
    </style>
    @include('admin.partials.styles')
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <!-- Header -->
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <div>
                <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">Video Consultations</h2>
            </div>
            <div class="flex items-center gap-3 pl-6">
                <div class="text-right hidden sm:block">
                    <p class="text-sm font-extrabold text-[#0f172a]">{{ auth()->user()->name }}</p>
                </div>
                <div
                    class="h-9 w-9 rounded-full bg-blue-600 flex items-center justify-center font-bold text-white shadow-lg shadow-blue-100">
                    {{ substr(auth()->user()->name, 0, 1) }}
                </div>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-white p-8">
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded relative"
                    role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif

            <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-slate-50">
                            <tr class="text-left text-xs font-bold text-slate-500 uppercase tracking-widest">
                                <th class="px-6 py-4">Client</th>
                                <th class="px-6 py-4">Status</th>
                                <th class="px-6 py-4">Date & Time</th>
                                <th class="px-6 py-4">Contact</th>
                                <th class="px-6 py-4">Message</th>
                                <th class="px-6 py-4">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100">
                            @forelse($bookings as $booking)
                                                    <tr class="hover:bg-slate-50 transition">
                                                        <td class="px-6 py-4">
                                                            <p class="font-bold text-[#0f172a]">{{ $booking->name }}</p>
                                                            <p class="text-xs text-slate-500">{{ $booking->created_at->format('M d, Y') }}</p>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <form action="{{ route('admin.consultations.updateStatus', $booking->id) }}"
                                                                method="POST">
                                                                @csrf
                                                                @method('PATCH')
                                                                <select name="status" onchange="this.form.submit()"
                                                                    class="text-xs font-bold uppercase tracking-widest rounded border-none py-1 pl-2 pr-6 cursor-pointer focus:ring-2 focus:ring-offset-1 focus:ring-indigo-500
                                                                        {{ $booking->status == 'confirmed' ? 'bg-green-100 text-green-700' :
                                ($booking->status == 'completed' ? 'bg-blue-100 text-blue-700' :
                                    ($booking->status == 'cancelled' ? 'bg-red-100 text-red-700' : 'bg-yellow-100 text-yellow-700')) }}">
                                                                    <option value="pending" {{ $booking->status == 'pending' ? 'selected' : '' }}>
                                                                        Pending</option>
                                                                    <option value="confirmed" {{ $booking->status == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                                                                    <option value="completed" {{ $booking->status == 'completed' ? 'selected' : '' }}>Completed</option>
                                                                    <option value="cancelled" {{ $booking->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                                                </select>
                                                            </form>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <p class="text-sm font-bold">{{ $booking->date->format('M d, Y') }}</p>
                                                            <p class="text-xs text-slate-500">{{ $booking->time_slot }}</p>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <p class="text-sm font-bold">{{ $booking->email }}</p>
                                                            <p class="text-xs text-slate-500">{{ $booking->phone }}</p>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <div class="max-w-xs truncate text-xs text-slate-600"
                                                                title="{{ $booking->message }}">
                                                                {{ $booking->message ?? '-' }}
                                                            </div>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <form action="{{ route('admin.consultations.destroy', $booking->id) }}"
                                                                method="POST" onsubmit="return confirm('Delete booking?');">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit"
                                                                    class="text-red-500 hover:text-red-700 font-bold text-xs uppercase tracking-widest">Delete</button>
                                                            </form>
                                                        </td>
                                                    </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-8 text-center text-slate-400 italic">No bookings found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="px-6 py-4 border-t border-slate-50">
                    {{ $bookings->links() }}
                </div>
            </div>
        </main>
    </div>
</body>

</html>