<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Client Details - Hair Niche Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <a href="{{ route('admin.clients.index') }}" class="mr-4 text-gray-500 hover:text-gray-700">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                </a>
                <h2 class="text-2xl font-semibold text-gray-800">{{ $client->name }}</h2>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Client Profile -->
                <div class="md:col-span-1 space-y-6">
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <div class="text-center mb-6">
                            @if($client->profile_photo_path)
                                <img class="h-24 w-24 rounded-full mx-auto object-cover mb-4"
                                    src="{{ Storage::url($client->profile_photo_path) }}" alt="{{ $client->name }}">
                            @else
                                <div
                                    class="h-24 w-24 rounded-full mx-auto bg-blue-100 flex items-center justify-center mb-4">
                                    <span
                                        class="text-2xl font-bold text-blue-600">{{ strtoupper(substr($client->name, 0, 2)) }}</span>
                                </div>
                            @endif
                            <h3 class="text-xl font-bold text-gray-900">{{ $client->name }}</h3>
                            <p class="text-sm text-gray-500">{{ $client->email }}</p>
                        </div>
                        <div class="border-t border-gray-100 pt-4 space-y-3">
                            <div>
                                <label class="text-xs font-semibold text-gray-500 uppercase">Joined On</label>
                                <p class="text-gray-900">{{ $client->created_at->format('M d, Y') }}</p>
                            </div>
                            <div>
                                <label class="text-xs font-semibold text-gray-500 uppercase">Status</label>
                                <span
                                    class="px-2 py-1 rounded-full text-xs font-semibold {{ $client->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $client->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>
                            <!-- FCM Token Section -->
                            <div class="pt-3 border-t border-gray-100 mt-2">
                                <label class="text-xs font-semibold text-gray-500 uppercase">Device Token (FCM)</label>
                                <div class="mt-1 flex items-start gap-2">
                                    @if($client->fcm_token)
                                        <div class="relative group flex-1">
                                            <code
                                                class="block text-xs bg-gray-100 p-2 rounded text-gray-600 truncate max-w-[200px]"
                                                title="{{ $client->fcm_token }}">
                                                    {{ Str::limit($client->fcm_token, 20) }}
                                                </code>
                                            <!-- Full token on hover tooltip -->
                                            <div
                                                class="absolute bottom-full left-0 mb-2 w-64 bg-gray-800 text-white text-xs rounded p-2 hidden group-hover:block z-10 break-all">
                                                {{ $client->fcm_token }}
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-xs text-orange-500 italic flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                            Not synced yet
                                        </span>
                                    @endif
                                </div>
                            </div>

                            @if($client->fcm_token)
                                <div x-data="{ showNotify: false }" class="pt-2">
                                    <button @click="showNotify = !showNotify"
                                        class="w-full py-2 px-3 bg-indigo-50 text-indigo-700 text-sm font-medium rounded-lg hover:bg-indigo-100 transition-colors flex items-center justify-center gap-2">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9">
                                            </path>
                                        </svg>
                                        Send Notification
                                    </button>

                                    <div x-show="showNotify" x-transition
                                        class="mt-3 bg-gray-50 p-3 rounded-lg border border-gray-200">
                                        <form action="{{ route('admin.clients.send-notification', $client->id) }}"
                                            method="POST" class="space-y-3">
                                            @csrf
                                            <div>
                                                <label class="block text-xs font-medium text-gray-700">Title</label>
                                                <input type="text" name="title" required
                                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm text-xs py-1.5"
                                                    placeholder="Notification Title">
                                            </div>
                                            <div>
                                                <label class="block text-xs font-medium text-gray-700">Message</label>
                                                <textarea name="body" required rows="3"
                                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm text-xs"
                                                    placeholder="Type message..."></textarea>
                                            </div>
                                            <div class="flex justify-end gap-2 pt-1">
                                                <button type="button" @click="showNotify = false"
                                                    class="px-2 py-1 text-xs text-gray-600 hover:text-gray-800">Cancel</button>
                                                <button type="submit"
                                                    class="px-3 py-1 bg-indigo-600 text-white text-xs font-medium rounded hover:bg-indigo-700">Send</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Recent Activity & Stats -->
                <div class="md:col-span-2 space-y-6">
                                <!-- Stats -->
                                <div class="grid grid-cols-2 gap-4">
                                    <div class="bg-white p-6 rounded-xl shadow-sm">
                                        <div class="text-sm font-medium text-gray-500">Total Orders</div>
                                        <div class="mt-2 text-3xl font-bold text-gray-900">{{ $client->orders_count }}
                                        </div>
                                        <a href="{{ route('admin.clients.orders', $client->id) }}"
                                            class="text-blue-600 text-sm hover:underline mt-2 inline-block">View All
                                            Orders
                                            &rarr;</a>
                                    </div>
                                    <div class="bg-white p-6 rounded-xl shadow-sm">
                                        <!-- Placeholder for Total Spent or other stats -->
                                        <div class="text-sm font-medium text-gray-500">Total Spent</div>
                                        <div class="mt-2 text-3xl font-bold text-gray-900">
                                            @php
                                                // Calculate simplistic total if loaded, usually done in controller
                                                $totalSpent = $client->orders->sum('total_amount'); // Assuming 'orders' relation is loaded
                                            @endphp
                                            ₹{{ number_format($totalSpent, 2) }}
                                        </div>
                                    </div>
                                </div>

                                <!-- Recent Orders -->
                                <div class="bg-white rounded-xl shadow-sm overflow-hidden">
                                    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
                                        <h3 class="font-bold text-gray-900">Recent Orders</h3>
                                    </div>
                                    <table class="w-full">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                                    Order #
                                                </th>
                                                <th
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                                    Date
                                                </th>
                                                <th
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                                    Status
                                                </th>
                                                <th
                                                    class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">
                                                    Amount
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody class="divide-y divide-gray-200">
                                            @forelse($recentOrders as $order)
                                                                                    <tr>
                                                                                        <td
                                                                                            class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600">
                                                                                            #{{ $order->order_number ?? $order->id }}
                                                                                        </td>
                                                                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                                                            {{ $order->created_at->format('M d, Y') }}
                                                                                        </td>
                                                                                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                                                                                            <span
                                                                                                class="px-2 py-1 rounded-full text-xs font-semibold
                                                                                                                                                {{ $order->status == 'completed' ? 'bg-green-100 text-green-800' :
                                                ($order->status == 'cancelled' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">
                                                                                                {{ ucfirst($order->status) }}
                                                                                            </span>
                                                                                        </td>
                                                                                        <td
                                                                                            class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right">
                                                                                            ₹{{ number_format($order->total_amount, 2) }}
                                                                                        </td>
                                                                                    </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="4" class="px-6 py-4 text-center text-sm text-gray-500">No
                                                        recent
                                                        orders.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
        </main>
    </div>
</body>

</html>