<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Chatbot Settings - Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Outfit', 'Inter', sans-serif;
        }
    </style>
    @include('admin.partials.styles')
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <!-- Header -->
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <div>
                <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">AI Chatbot Management</h2>
            </div>
            <!-- Profile (Simplified for brevity) -->
            <div class="flex items-center gap-3 pl-6">
                <div class="text-right hidden sm:block">
                    <p class="text-sm font-extrabold text-[#0f172a]">{{ auth()->user()->name }}</p>
                </div>
                <div
                    class="h-9 w-9 rounded-full bg-blue-600 flex items-center justify-center font-bold text-white shadow-lg shadow-blue-100">
                    {{ substr(auth()->user()->name, 0, 1) }}
                </div>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-white p-8">
            <!-- Messages -->
            @if(session('success'))
                <div class="mb-6 bg-emerald-50 border border-emerald-200 text-emerald-700 px-6 py-4 rounded-2xl flex items-center gap-3 shadow-sm"
                    role="alert">
                    <svg class="w-5 h-5 text-emerald-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                    </svg>
                    <span class="font-bold text-sm">{{ session('success') }}</span>
                </div>
            @endif

            @if($errors->any())
                <div class="mb-6 bg-rose-50 border border-rose-200 text-rose-700 px-6 py-4 rounded-2xl shadow-sm"
                    role="alert">
                    <div class="flex items-center gap-3 mb-2">
                        <svg class="w-5 h-5 text-rose-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="font-black text-sm uppercase tracking-tight">Configuration Error</span>
                    </div>
                    <ul class="list-disc list-inside text-xs font-medium space-y-1">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Settings Column -->
                <div class="lg:col-span-1 space-y-8">
                    <!-- Configuration Card -->
                    <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
                        <div class="p-6 border-b border-slate-50 bg-slate-50/50">
                            <h3 class="text-lg font-black text-[#0f172a]">Bot Configuration</h3>
                        </div>
                        <div class="p-6">
                            <form action="{{ route('admin.chatbot.update-settings') }}" method="POST">
                                @csrf
                                <div class="space-y-6">
                                    <!-- Bot Name & Status Row -->
                                    <div class="grid grid-cols-1 gap-4">
                                        <div>
                                            <label
                                                class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">Bot
                                                Name</label>
                                            <input type="text" name="name" value="{{ $chatbotSettings->name }}"
                                                placeholder="e.g. Sales Assistant"
                                                class="w-full rounded-xl border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 font-bold text-sm h-11">
                                        </div>
                                    </div>

                                    <!-- Color Scheme -->
                                    <div>
                                        <label
                                            class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">Color
                                            Scheme</label>
                                        <div class="flex items-center gap-3">
                                            <input type="color" name="color_scheme"
                                                value="{{ $chatbotSettings->color_scheme }}"
                                                class="h-11 w-20 rounded-xl cursor-pointer border border-slate-200 bg-white p-1">
                                            <input type="text" value="{{ $chatbotSettings->color_scheme }}" readonly
                                                class="flex-1 h-11 rounded-xl border-slate-200 bg-slate-50 text-slate-500 font-mono text-xs text-center">
                                        </div>
                                    </div>

                                    <!-- Bot Online Toggle -->
                                    <div
                                        class="flex items-center justify-between p-4 rounded-xl bg-slate-50 border border-slate-100">
                                        <div>
                                            <p class="text-sm font-bold text-slate-700">Bot Online</p>
                                            <p class="text-[10px] text-slate-400 font-medium">Show/Hide bot on website
                                            </p>
                                        </div>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="is_active" value="1" {{ $chatbotSettings->is_active ? 'checked' : '' }} class="sr-only peer">
                                            <div
                                                class="w-11 h-6 bg-slate-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-500">
                                            </div>
                                        </label>
                                    </div>

                                    <!-- Messages -->
                                    <div>
                                        <label
                                            class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">Welcome
                                            Message</label>
                                        <textarea name="welcome_message" rows="3"
                                            placeholder="How can I help you today?"
                                            class="w-full rounded-xl border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 font-medium text-sm p-3">{{ $chatbotSettings->welcome_message }}</textarea>
                                    </div>
                                    <div>
                                        <label
                                            class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">System
                                            Instructions (Persona)</label>
                                        <textarea name="system_prompt" rows="3"
                                            placeholder="You are a helpful assistant for Hair Niche..."
                                            class="w-full rounded-xl border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 font-medium text-sm p-3">{{ $chatbotSettings->system_prompt }}</textarea>
                                    </div>

                                    <button type="submit"
                                        class="w-full bg-indigo-600 text-white font-bold py-3 px-4 rounded-xl hover:bg-indigo-700 transition duration-150 shadow-lg shadow-indigo-100 mt-2">
                                        Update Configuration
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Scan Website Card -->
                    <div
                        class="bg-gradient-to-br from-indigo-500 to-purple-600 rounded-2xl p-6 text-white shadow-xl shadow-indigo-200">
                        <h3 class="text-lg font-black mb-2">Auto-Learning</h3>
                        <p class="text-indigo-100 text-sm mb-6">Train the bot by scanning website functionalities like
                            policies, ordering process, and account management.</p>
                        <form action="{{ route('admin.chatbot.learn') }}" method="POST">
                            @csrf
                            <button type="submit"
                                class="w-full bg-white text-indigo-600 font-bold py-3 px-4 rounded-xl hover:bg-indigo-50 transition shadow-lg">
                                Scan & Learn Functionalities
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Knowledge Base Column -->
                <div class="lg:col-span-2 space-y-8">
                    <!-- Manual Training -->
                    <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
                        <div class="p-6 border-b border-slate-50 bg-slate-50/50">
                            <h3 class="text-lg font-black text-[#0f172a]">Manual Training</h3>
                        </div>
                        <div class="p-6">
                            <form action="{{ route('admin.chatbot.training.store') }}" method="POST" class="space-y-6">
                                @csrf
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label
                                            class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">Topic
                                            (Optional)</label>
                                        <input type="text" name="topic" placeholder="e.g. Refunds"
                                            class="w-full rounded-xl border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 text-sm h-11">
                                    </div>
                                    <div>
                                        <label
                                            class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">Question
                                            / Trigger</label>
                                        <input type="text" name="question" required
                                            placeholder="What does the user ask?"
                                            class="w-full rounded-xl border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 text-sm h-11">
                                    </div>
                                </div>
                                <div>
                                    <label
                                        class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">Keywords
                                        (Like Operator / Comma separated)</label>
                                    <input type="text" name="keywords"
                                        placeholder="e.g. hair topper, topper, want hair topper"
                                        class="w-full rounded-xl border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 text-sm h-11">
                                </div>
                                <div>
                                    <label
                                        class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1.5">Bot
                                        Answer</label>
                                    <textarea name="answer" required rows="3" placeholder="What should the bot reply?"
                                        class="w-full rounded-xl border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 text-sm p-3"></textarea>
                                </div>
                                <div class="flex justify-end">
                                    <button type="submit"
                                        class="bg-slate-900 text-white font-bold py-3 px-8 rounded-xl hover:bg-black transition shadow-lg shadow-slate-100 text-sm">
                                        Add to Knowledge Base
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Knowledge Base Table -->
                    <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
                        <div class="p-6 border-b border-slate-50 bg-slate-50/50 flex items-center justify-between">
                            <h3 class="text-lg font-black text-[#0f172a]">Knowledge Base</h3>
                            <span
                                class="px-3 py-1 bg-white border border-slate-100 rounded-full text-[10px] font-bold text-slate-500 uppercase tracking-widest shadow-sm">
                                {{ $knowledgeBase->count() }} Entries
                            </span>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="w-full border-collapse">
                                <thead class="bg-slate-50">
                                    <tr
                                        class="text-left text-[10px] font-extrabold text-slate-400 uppercase tracking-widest">
                                        <th class="px-6 py-4">Topic</th>
                                        <th class="px-6 py-4">Q & A</th>
                                        <th class="px-6 py-4">Source</th>
                                        <th class="px-6 py-4 text-right">Action</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-slate-100">
                                    @forelse($knowledgeBase as $item)
                                        <tr class="hover:bg-slate-50/50 transition-colors group">
                                            <td class="px-6 py-4">
                                                <span
                                                    class="px-2.5 py-1 rounded-lg bg-slate-100 text-[10px] font-bold text-slate-600">
                                                    {{ $item->topic ?? 'General' }}
                                                </span>
                                            </td>
                                            <td class="px-6 py-4">
                                                <p class="text-sm font-bold text-[#0f172a] mb-0.5">Q: {{ $item->question }}
                                                </p>
                                                @if($item->keywords)
                                                    <p class="text-[10px] text-indigo-500 font-bold mb-1 italic">K:
                                                        {{ $item->keywords }}
                                                    </p>
                                                @endif
                                                <p class="text-xs text-slate-500 line-clamp-2">A: {{ $item->answer }}</p>
                                            </td>
                                            <td class="px-6 py-4">
                                                <span
                                                    class="inline-flex items-center gap-1.5 px-2 py-1 rounded-full text-[9px] font-black uppercase tracking-widest {{ $item->type === 'learned' ? 'bg-indigo-50 text-indigo-600' : 'bg-emerald-50 text-emerald-600' }}">
                                                    <span
                                                        class="w-1 h-1 rounded-full {{ $item->type === 'learned' ? 'bg-indigo-500' : 'bg-emerald-500' }}"></span>
                                                    {{ $item->type }}
                                                </span>
                                            </td>
                                            <td class="px-6 py-4 text-right">
                                                <form action="{{ route('admin.chatbot.training.destroy', $item->id) }}"
                                                    method="POST" onsubmit="return confirm('Delete this entry?');"
                                                    class="opacity-0 group-hover:opacity-100 transition-opacity">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit"
                                                        class="text-red-400 hover:text-red-600 font-bold text-[10px] uppercase tracking-widest">
                                                        Delete
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4"
                                                class="px-6 py-12 text-center text-slate-400 italic font-medium">No
                                                knowledge base data yet. Start training or scan website!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <script>
        // Real-time Hex Preview for Bot Color
        document.querySelector('input[name="color_scheme"]').addEventListener('input', (e) => {
            e.target.nextElementSibling.value = e.target.value.toUpperCase();
        });
    </script>
</body>

</html>