<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Category - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    <!-- Sidebar -->
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <h2 class="text-2xl font-semibold text-gray-800">Edit Category</h2>
            </div>
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.categories.index') }}"
                    class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors">
                    <svg class="-ml-1 mr-2 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                    Back to List
                </a>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-2xl mx-auto bg-white rounded-xl shadow-sm p-8">

                @if ($errors->any())
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                        d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                        clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <ul class="list-disc list-inside text-sm text-red-700">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                @endif

                <form action="{{ route('admin.categories.update', $category->id) }}" method="POST"
                    enctype="multipart/form-data" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <!-- Parent Category -->
                    <div>
                        <label for="parent_id" class="block text-sm font-medium text-gray-700 mb-2">Parent Category
                            (Optional)</label>
                        <select name="parent_id" id="parent_id"
                            class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm bg-white">
                            <option value="">None (Top Level)</option>
                            @foreach($categories as $cat)
                                <option value="{{ $cat->id }}" {{ (old('parent_id', $category->parent_id) == $cat->id) ? 'selected' : '' }}>{{ $cat->name }}</option>
                            @endforeach
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Select a parent category to create a subcategory.</p>
                    </div>

                    <!-- Name -->
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Category Name</label>
                        <input type="text" name="name" id="name" required value="{{ old('name', $category->name) }}"
                            class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm"
                            placeholder="e.g., Electronics">
                    </div>

                    <!-- Slug -->
                    <div>
                        <label for="slug" class="block text-sm font-medium text-gray-700 mb-2">Slug (Optional)</label>
                        <input type="text" name="slug" id="slug" value="{{ old('slug', $category->slug) }}"
                            class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm"
                            placeholder="e.g., electronics-devices">
                        <p class="mt-1 text-xs text-gray-500">Leave blank to auto-generate from name.</p>
                    </div>

                    <!-- Image Upload -->
                    <div>
                        <label for="image" class="block text-sm font-medium text-gray-700 mb-2">Category Image</label>
                        @if($category->image_url)
                            <div class="mb-2">
                                <img src="{{ Str::startsWith($category->image_url, ['http://', 'https://']) ? $category->image_url : asset($category->image_url) }}"
                                    alt="Current Image" class="h-20 w-20 rounded-lg object-cover border border-gray-200">
                                <p class="text-xs text-gray-500 mt-1">Current Image</p>
                            </div>
                        @endif
                        <input type="file" name="image" id="image" accept="image/*"
                            class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                        <p class="mt-1 text-xs text-gray-500">Upload a new image to replace the current one. Max 5MB.
                        </p>
                    </div>

                    <!-- Schema Markup -->
                    <div>
                        <label for="schema_markup" class="block text-sm font-medium text-gray-700 mb-2">Schema Markup
                            (JSON-LD)</label>
                        <textarea name="schema_markup" id="schema_markup" rows="3"
                            class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm font-mono text-xs"
                            placeholder='<script type="application/ld+json">{ ... }</script>'>{{ old('schema_markup', $category->schema_markup) }}</textarea>
                        <p class="mt-1 text-xs text-gray-500">Paste your custom Schema.org JSON-LD code here.</p>
                    </div>

                    <!-- SEO Section -->
                    <div class="border-t pt-6 mt-6" x-data="{ 
                            seoTitle: '{{ addslashes(old('seo_title', $category->seo_title ?? '')) }}', 
                            metaDesc: '{{ addslashes(old('meta_description', $category->meta_description ?? '')) }}',
                            getWordCount(text) {
                                return text.trim().split(/\s+/).filter(word => word.length > 0).length;
                            },
                             getColorClass(current, max) {
                                const percentage = (current / max) * 100;
                                if (percentage > 100) return 'bg-red-500';
                                if (percentage > 80) return 'bg-yellow-500';
                                return 'bg-green-500';
                            },
                             getTextColorClass(current, max) {
                                const percentage = (current / max) * 100;
                                 if (percentage > 100) return 'text-red-600';
                                if (percentage > 80) return 'text-yellow-600';
                                return 'text-green-600';
                            }
                        }">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">SEO Settings</h3>

                        <!-- SEO Title -->
                        <div class="mb-4">
                            <div class="flex justify-between items-end mb-1">
                                <label for="seo_title" class="block text-sm font-medium text-gray-700">SEO
                                    Title</label>
                                <div class="text-xs text-gray-500 flex gap-2">
                                    <span><span x-text="getWordCount(seoTitle)">0</span> words</span>
                                    <span>|</span>
                                    <span :class="getTextColorClass(seoTitle.length, 60)">
                                        <span x-text="seoTitle.length">0</span>/60 chars
                                    </span>
                                </div>
                            </div>
                            <input type="text" name="seo_title" id="seo_title" x-model="seoTitle"
                                class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm mb-1"
                                placeholder="Custom SEO Title">
                            <!-- Progress Bar -->
                            <div class="w-full bg-gray-200 rounded-full h-1.5 dark:bg-gray-700">
                                <div class="h-1.5 rounded-full transition-all duration-300"
                                    :class="getColorClass(seoTitle.length, 60)"
                                    :style="`width: ${Math.min((seoTitle.length / 60) * 100, 100)}%`"></div>
                            </div>
                        </div>

                        <!-- Meta Description -->
                        <div class="mb-4">
                            <div class="flex justify-between items-end mb-1">
                                <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta
                                    Description</label>
                                <div class="text-xs text-gray-500 flex gap-2">
                                    <span><span x-text="getWordCount(metaDesc)">0</span> words</span>
                                    <span>|</span>
                                    <span :class="getTextColorClass(metaDesc.length, 160)">
                                        <span x-text="metaDesc.length">0</span>/160 chars
                                    </span>
                                </div>
                            </div>
                            <textarea name="meta_description" id="meta_description" rows="3" x-model="metaDesc"
                                class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm mb-1"></textarea>
                            <!-- Progress Bar -->
                            <div class="w-full bg-gray-200 rounded-full h-1.5 dark:bg-gray-700">
                                <div class="h-1.5 rounded-full transition-all duration-300"
                                    :class="getColorClass(metaDesc.length, 160)"
                                    :style="`width: ${Math.min((metaDesc.length / 160) * 100, 100)}%`"></div>
                            </div>
                        </div>

                        <!-- Breadcrumbs Title -->
                        <div class="mb-4">
                            <label for="breadcrumbs_title"
                                class="block text-sm font-medium text-gray-700 mb-2">Breadcrumbs Title</label>
                            <input type="text" name="breadcrumbs_title" id="breadcrumbs_title"
                                value="{{ old('breadcrumbs_title', $category->breadcrumbs_title) }}"
                                class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm"
                                placeholder="Short title for breadcrumbs">
                        </div>

                        <!-- Canonical URL -->
                        <div class="mb-4">
                            <label for="canonical_url" class="block text-sm font-medium text-gray-700 mb-2">Canonical
                                URL</label>
                            <input type="url" name="canonical_url" id="canonical_url"
                                value="{{ old('canonical_url', $category->canonical_url) }}"
                                class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 outline-none sm:text-sm"
                                placeholder="https://example.com/custom-canonical">
                        </div>

                        <!-- Robots Meta -->
                        <div class="mb-4">
                            <label class="flex items-center space-x-3">
                                <input type="checkbox" name="is_nofollow" value="1" {{ old('is_nofollow', $category->is_nofollow ?? false) ? 'checked' : '' }}
                                    class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                <span class="text-sm font-medium text-gray-700">Set rel="nofollow" for this category
                                    link</span>
                            </label>
                            <p class="mt-1 text-xs text-gray-500 ml-7">If checked, search engines will be instructed not
                                to follow links to this category page.</p>
                        </div>
                    </div>

                    <!-- Status -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                        <div class="flex items-center space-x-4">
                            <div class="flex items-center">
                                <input id="status_active" name="status" type="radio" value="1" {{ old('status', $category->status) ? 'checked' : '' }}
                                    class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300">
                                <label for="status_active" class="ml-2 block text-sm text-gray-700">Active</label>
                            </div>
                            <div class="flex items-center">
                                <input id="status_inactive" name="status" type="radio" value="0" {{ !old('status', $category->status) ? 'checked' : '' }}
                                    class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300">
                                <label for="status_inactive" class="ml-2 block text-sm text-gray-700">Inactive</label>
                            </div>
                        </div>
                    </div>

                    <div class="pt-4">
                        <button type="submit"
                            class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-200 transform hover:-translate-y-0.5">
                            Update Category
                        </button>
                    </div>

                </form>
            </div>
        </main>
    </div>
</body>

</html>