@extends('layouts.admin')

@section('title', 'Campaign Delivery Logs')

@section('content')
    <div class="space-y-6 max-w-7xl mx-auto">
        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h2 class="text-3xl font-bold text-gray-900">Delivery Logs</h2>
                <p class="text-gray-500 mt-1">Tracking logs for campaign: <span
                        class="font-semibold text-gray-700">{{ $campaign->subject }}</span></p>
            </div>
            <div class="flex gap-3">
                <a href="{{ route('admin.bulk-email.index') }}"
                    class="bg-white hover:bg-gray-50 text-gray-700 font-semibold py-2 px-4 border border-gray-300 rounded-lg shadow-sm transition-colors duration-200">
                    Back to Campaigns
                </a>
                <form action="{{ route('admin.bulk-email.resend', $campaign->id) }}" method="POST">
                    @csrf
                    <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg shadow-sm transition-colors duration-200 flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                            </path>
                        </svg>
                        Resend All
                    </button>
                </form>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <!-- Total Attempts -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h4 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Total Attempts</h4>
                <div class="flex items-baseline">
                    <span class="text-3xl font-bold text-gray-900">{{ $logs->total() }}</span>
                </div>
            </div>

            <!-- Sent / Delivered -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h4 class="text-xs font-semibold text-green-600 uppercase tracking-wider mb-2">Sent / Delivered</h4>
                <div class="flex items-baseline">
                    <span
                        class="text-3xl font-bold text-green-600">{{ $campaign->logs()->where('status', 'sent')->count() }}</span>
                </div>
            </div>

            <!-- Bounced / Failed -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h4 class="text-xs font-semibold text-red-600 uppercase tracking-wider mb-2">Bounced / Failed</h4>
                <div class="flex items-baseline">
                    <span
                        class="text-3xl font-bold text-red-600">{{ $campaign->logs()->where('status', 'failed')->count() }}</span>
                </div>
            </div>

            <!-- Last Activity -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h4 class="text-xs font-semibold text-blue-600 uppercase tracking-wider mb-2">Last Activity</h4>
                <div class="text-sm font-medium text-gray-900">
                    @if($campaign->logs()->latest('created_at')->first())
                        {{ $campaign->logs()->latest('created_at')->first()->created_at->diffForHumans() }}
                    @else
                        None
                    @endif
                </div>
            </div>
        </div>

        <!-- Logs Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-900 text-white">
                        <tr>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-bold uppercase tracking-wider">Recipient
                                Email</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-bold uppercase tracking-wider">Status
                            </th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-bold uppercase tracking-wider">Message
                                ID</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-bold uppercase tracking-wider">Time</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-bold uppercase tracking-wider">Error
                                Details</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($logs as $log)
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ $log->recipient_email }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span
                                        class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                    {{ $log->status === 'sent' ? 'bg-green-100 text-green-800' : '' }}
                                                    {{ $log->status === 'failed' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800' }}">
                                        {{ ucfirst($log->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500 font-mono">
                                    {{ $log->message_id ?? '-' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $log->created_at->format('M d, H:i:s') }}
                                </td>
                                <td class="px-6 py-4 text-sm text-red-500 max-w-xs truncate" title="{{ $log->error_details }}">
                                    {{ $log->error_details ?? '-' }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center text-gray-500 italic">
                                    No logs found for this campaign.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($logs->hasPages())
                <div class="px-6 py-4 border-t border-gray-200 bg-gray-50">
                    {{ $logs->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection