@extends('layouts.admin')

@section('title', 'Create Email Campaign')

@section('content')
    <div class="space-y-8 max-w-5xl mx-auto">
        <!-- Header -->
        <div class="flex justify-between items-center">
            <h2 class="text-2xl font-bold text-gray-800">Design and schedule a new email broadcast.</h2>
        </div>

        @if(session('success'))
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded-md" role="alert">
                <p>{{ session('success') }}</p>
            </div>
        @endif

        @if($errors->any())
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded-md" role="alert">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('admin.bulk-email.send') }}" method="POST" enctype="multipart/form-data" x-data="{ 
                              recipientType: 'all',
                              templates: {{ $templates->toJson() }},
                              selectedTemplateId: '',
                              subject: '',
                              updateSubject() {
                                  const template = this.templates.find(t => t.id == this.selectedTemplateId);
                                  if(template) {
                                      this.subject = template.subject;
                                  } else {
                                      this.subject = '';
                                  }
                              }
                          }">
            @csrf

            <!-- Step 1: Campaign Details -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8 mb-6">
                <div class="flex items-start gap-4">
                    <div
                        class="flex-shrink-0 w-8 h-8 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center font-bold text-sm">
                        1</div>
                    <div class="flex-1">
                        <h3 class="text-lg font-bold text-gray-800 mb-4">Campaign Details</h3>

                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Campaign Name /
                                    Subject</label>
                                <input type="text" name="subject" x-model="subject" required
                                    placeholder="e.g. Monthly Newsletter - January"
                                    class="w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-sm py-3 px-4 border transition-colors">
                                <p class="text-xs text-gray-500 mt-2">This will be the subject line of your email.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 2: Target Audience -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8 mb-6">
                <div class="flex items-start gap-4">
                    <div
                        class="flex-shrink-0 w-8 h-8 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center font-bold text-sm">
                        2</div>
                    <div class="flex-1">
                        <h3 class="text-lg font-bold text-gray-800 mb-4">Target Audience</h3>
                        <p class="text-sm text-gray-600 mb-6">Who should receive this email?</p>

                        <!-- Hidden Input for Form Submission -->
                        <input type="hidden" name="recipient_type" x-model="recipientType">

                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                            <!-- All Users Card -->
                            <div @click="recipientType = 'all'"
                                class="relative border rounded-xl p-6 cursor-pointer transition-all duration-200 group"
                                :class="recipientType === 'all' ? 'border-blue-500 bg-blue-50/30 ring-1 ring-blue-500' : 'border-gray-200 hover:border-blue-300 hover:shadow-md'">
                                <div class="flex justify-between items-start mb-2">
                                    <span class="font-bold text-gray-800">All Users</span>
                                    <div x-show="recipientType === 'all'" class="text-blue-600">
                                        <svg class="w-5 h-5 fill-current" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd"></path>
                                        </svg>
                                    </div>
                                </div>
                                <p class="text-sm text-gray-500">Send to all registered users in the database.</p>
                            </div>

                            <!-- Single Recipient Card -->
                            <div @click="recipientType = 'single'"
                                class="relative border rounded-xl p-6 cursor-pointer transition-all duration-200 group"
                                :class="recipientType === 'single' ? 'border-blue-500 bg-blue-50/30 ring-1 ring-blue-500' : 'border-gray-200 hover:border-blue-300 hover:shadow-md'">
                                <div class="flex justify-between items-start mb-2">
                                    <span class="font-bold text-gray-800">Single Recipient</span>
                                    <div x-show="recipientType === 'single'" class="text-blue-600">
                                        <svg class="w-5 h-5 fill-current" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd"></path>
                                        </svg>
                                    </div>
                                </div>
                                <p class="text-sm text-gray-500">Send to a specific user account.</p>
                            </div>

                            <!-- Custom Upload Card -->
                            <div @click="recipientType = 'excel'"
                                class="relative border rounded-xl p-6 cursor-pointer transition-all duration-200 group"
                                :class="recipientType === 'excel' ? 'border-blue-500 bg-blue-50/30 ring-1 ring-blue-500' : 'border-gray-200 hover:border-blue-300 hover:shadow-md'">
                                <div class="flex justify-between items-start mb-2">
                                    <span class="font-bold text-gray-800">Custom Upload</span>
                                    <div x-show="recipientType === 'excel'" class="text-blue-600">
                                        <svg class="w-5 h-5 fill-current" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd"></path>
                                        </svg>
                                    </div>
                                </div>
                                <p class="text-sm text-gray-500">Upload a CSV or Excel file with email addresses.</p>
                            </div>
                        </div>

                        <!-- Dynamic Inputs for Selection -->
                        <div x-show="recipientType === 'single'" x-transition
                            class="bg-gray-50 p-6 rounded-xl border border-dashed border-gray-300">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Select User</label>
                            <select name="user_id"
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm py-2 px-3 border">
                                <option value="">Search and select a user...</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})</option>
                                @endforeach
                            </select>
                        </div>

                        <div x-show="recipientType === 'excel'" x-transition
                            class="bg-gray-50 p-6 rounded-xl border border-dashed border-gray-300">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Upload Excel/CSV File</label>
                            <div class="flex items-center justify-center w-full">
                                <label
                                    class="flex flex-col items-center justify-center w-full h-32 border-2 border-gray-300 border-dashed rounded-lg cursor-pointer bg-white hover:bg-gray-50">
                                    <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                        <svg class="w-8 h-8 mb-4 text-gray-500" aria-hidden="true"
                                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 16">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                                stroke-width="2"
                                                d="M13 13h3a3 3 0 0 0 0-6h-.025A5.56 5.56 0 0 0 16 6.5 5.5 5.5 0 0 0 5.207 5.021C5.137 5.017 5.071 5 5 5a4 4 0 0 0 0 8h2.167M10 15V6m0 0L8 8m2-2 2 2" />
                                        </svg>
                                        <p class="mb-2 text-sm text-gray-500"><span class="font-semibold">Click to
                                                upload</span> or drag and drop</p>
                                        <p class="text-xs text-gray-500">XLSX, XLS or CSV (MAX. 5MB)</p>
                                    </div>
                                    <input type="file" name="file" accept=".xlsx, .xls, .csv" class="hidden" />
                                </label>
                            </div>
                            <p class="text-xs text-gray-500 mt-2">File must contain an 'email' column or list emails in the
                                first column.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 3: Message Content -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8 mb-6">
                <div class="flex items-start gap-4">
                    <div
                        class="flex-shrink-0 w-8 h-8 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center font-bold text-sm">
                        3</div>
                    <div class="flex-1">
                        <h3 class="text-lg font-bold text-gray-800 mb-4">Message Content</h3>

                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Select Template</label>
                                <select name="template_id" x-model="selectedTemplateId" @change="updateSubject()" required
                                    class="w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-sm py-3 px-4 border transition-colors">
                                    <option value="">Choose an email template...</option>
                                    <template x-for="template in templates" :key="template.id">
                                        <option :value="template.id" x-text="template.name"></option>
                                    </template>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="flex justify-end pt-4 mb-12">
                <button type="submit"
                    class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg shadow-blue-500/30 transition-all duration-200 transform hover:-translate-y-1">
                    Send Campaign
                </button>
            </div>
        </form>


        <!-- Analytics Section -->
        <div class="mt-12">
            <h3 class="text-xl font-bold text-gray-800 mb-6">Recent Campaigns</h3>
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col"
                                    class="px-6 py-4 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                    Date</th>
                                <th scope="col"
                                    class="px-6 py-4 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                    Campaign Name</th>
                                <th scope="col"
                                    class="px-6 py-4 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                    Audience</th>
                                <th scope="col"
                                    class="px-6 py-4 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                    Sent</th>
                                <th scope="col"
                                    class="px-6 py-4 text-left text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                    Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($campaigns as $campaign)
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                        {{ $campaign->created_at->format('M d, Y') }}<br>
                                        <span class="text-xs text-gray-400">{{ $campaign->created_at->format('h:i A') }}</span>
                                    </td>
                                    <td class="px-6 py-4 text-sm font-medium text-gray-900">
                                        {{ $campaign->subject }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                                        {{ $campaign->recipient_type === 'all' ? 'bg-purple-100 text-purple-800' : '' }}
                                                                        {{ $campaign->recipient_type === 'single' ? 'bg-blue-100 text-blue-800' : '' }}
                                                                        {{ $campaign->recipient_type === 'excel' ? 'bg-orange-100 text-orange-800' : '' }}">
                                            {{ ucfirst($campaign->recipient_type) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-700">
                                        {{ $campaign->sent_count }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 flex items-center gap-3">
                                        <a href="{{ route('admin.bulk-email.logs', $campaign->id) }}"
                                            class="text-indigo-600 hover:text-indigo-900 font-medium">View Logs</a>

                                        <form action="{{ route('admin.bulk-email.destroy', $campaign->id) }}" method="POST"
                                            onsubmit="return confirm('Are you sure you want to delete this campaign?');"
                                            class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-900"
                                                title="Delete Campaign">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                </svg>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-6 py-8 text-sm text-gray-500 text-center italic">
                                        No email campaigns sent yet. Start your first broadcast above.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($campaigns->hasPages())
                    <div class="px-6 py-4 border-t border-gray-200 bg-gray-50">
                        {{ $campaigns->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection