<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Journey Viewer - Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>body { font-family: 'Outfit', sans-serif; }</style>
</head>
<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">User Journey: {{ Str::limit($sessionId, 8) }}</h2>
            <a href="{{ route('admin.analytics.funnel') }}" class="text-xs font-bold uppercase tracking-widest text-[#0f172a] hover:text-blue-600 transition-colors">Back to Analytics</a>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-slate-50 p-8">
            <div class="max-w-4xl mx-auto">
                <div class="space-y-6 relative ml-4 pl-8 border-l-2 border-slate-200">
                    @foreach($activities as $activity)
                        <div class="relative">
                             <div class="absolute -left-[41px] top-1 w-5 h-5 rounded-full border-2 border-white 
                                @if($activity->event_type == 'purchase') bg-emerald-500
                                @elseif($activity->event_type == 'add_to_cart') bg-purple-500
                                @elseif($activity->event_type == 'initiate_checkout') bg-amber-500
                                @else bg-slate-300 @endif"></div>
                            
                            <div class="bg-white rounded-xl p-4 shadow-sm border border-slate-100">
                                <div class="flex items-center justify-between mb-2">
                                    <h4 class="font-bold text-sm text-[#0f172a] uppercase tracking-wide">
                                        {{ str_replace('_', ' ', $activity->event_type) }}
                                    </h4>
                                    <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">{{ $activity->created_at->format('H:i:s') }}</span>
                                </div>
                                
                                @if($activity->url)
                                    <p class="text-xs text-slate-500 mb-1 truncate">{{ $activity->url }}</p>
                                @endif

                                @if($activity->meta_data)
                                    <div class="bg-slate-50 rounded-lg p-3 text-xs font-mono text-slate-600 mt-2">
                                        @foreach($activity->meta_data as $key => $val)
                                            <div class="flex justify-between">
                                                <span class="font-bold text-slate-400">{{ $key }}:</span>
                                                <span>{{ is_array($val) ? json_encode($val) : $val }}</span>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                     
                     <div class="relative">
                         <!-- Bounce Marker if last event was long ago -->
                         <div class="absolute -left-[41px] top-1 w-5 h-5 rounded-full bg-red-100 border-2 border-white flex items-center justify-center">
                             <div class="w-2 h-2 bg-red-500 rounded-full"></div>
                         </div>
                         <div class="text-xs font-bold text-slate-400 uppercase tracking-widest pl-2 pt-1">Session Ended / Inactive</div>
                     </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
