<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Funnel Analysis - Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
    </style>
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">Funnel Analytics</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-slate-50 p-8">
            <div class="max-w-7xl mx-auto space-y-8">

                <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-100">
                    <h3 class="text-lg font-bold mb-6 uppercase tracking-wider text-slate-700">Conversion Funnel</h3>

                    <div class="relative flex items-center justify-between">
                        <!-- Step 1: Visitors -->
                        <div class="flex-1 text-center relative z-10">
                            <div
                                class="w-16 h-16 mx-auto bg-blue-100 rounded-full flex items-center justify-center mb-2 shadow-sm text-blue-600">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z">
                                    </path>
                                </svg>
                            </div>
                            <h4 class="font-bold text-sm text-slate-600 uppercase tracking-wide">Visitors</h4>
                            <p class="text-2xl font-black text-[#0f172a] mt-1">{{ $funnelData['visitors'] }}</p>
                        </div>

                        <!-- Connector -->
                        <div class="flex-1 h-1 bg-slate-100 relative">
                            <span
                                class="absolute top-[-20px] left-1/2 transform -translate-x-1/2 text-xs font-bold text-slate-400">
                                {{ $funnelData['visitors'] > 0 ? round(($funnelData['interest'] / $funnelData['visitors']) * 100, 1) . '%' : '0%' }}
                            </span>
                        </div>

                        <!-- Step 2: Interest -->
                        <div class="flex-1 text-center relative z-10">
                            <div
                                class="w-16 h-16 mx-auto bg-indigo-100 rounded-full flex items-center justify-center mb-2 shadow-sm text-indigo-600">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                    </path>
                                </svg>
                            </div>
                            <h4 class="font-bold text-sm text-slate-600 uppercase tracking-wide">Interest</h4>
                            <p class="text-2xl font-black text-[#0f172a] mt-1">{{ $funnelData['interest'] }}</p>
                        </div>

                        <!-- Connector -->
                        <div class="flex-1 h-1 bg-slate-100 relative">
                            <span
                                class="absolute top-[-20px] left-1/2 transform -translate-x-1/2 text-xs font-bold text-slate-400">
                                {{ $funnelData['interest'] > 0 ? round(($funnelData['desire'] / $funnelData['interest']) * 100, 1) . '%' : '0%' }}
                            </span>
                        </div>

                        <!-- Step 3: Desire -->
                        <div class="flex-1 text-center relative z-10">
                            <div
                                class="w-16 h-16 mx-auto bg-purple-100 rounded-full flex items-center justify-center mb-2 shadow-sm text-purple-600">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z">
                                    </path>
                                </svg>
                            </div>
                            <h4 class="font-bold text-sm text-slate-600 uppercase tracking-wide">Added to Cart</h4>
                            <p class="text-2xl font-black text-[#0f172a] mt-1">{{ $funnelData['desire'] }}</p>
                        </div>

                        <!-- Connector -->
                        <div class="flex-1 h-1 bg-slate-100 relative">
                            <span
                                class="absolute top-[-20px] left-1/2 transform -translate-x-1/2 text-xs font-bold text-slate-400">
                                {{ $funnelData['desire'] > 0 ? round(($funnelData['action'] / $funnelData['desire']) * 100, 1) . '%' : '0%' }}
                            </span>
                        </div>

                        <!-- Step 4: Action -->
                        <div class="flex-1 text-center relative z-10">
                            <div
                                class="w-16 h-16 mx-auto bg-amber-100 rounded-full flex items-center justify-center mb-2 shadow-sm text-amber-600">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                                    </path>
                                </svg>
                            </div>
                            <h4 class="font-bold text-sm text-slate-600 uppercase tracking-wide">Checkout</h4>
                            <p class="text-2xl font-black text-[#0f172a] mt-1">{{ $funnelData['action'] }}</p>
                        </div>

                        <!-- Connector -->
                        <div class="flex-1 h-1 bg-slate-100 relative">
                            <span
                                class="absolute top-[-20px] left-1/2 transform -translate-x-1/2 text-xs font-bold text-slate-400">
                                {{ $funnelData['action'] > 0 ? round(($funnelData['conversion'] / $funnelData['action']) * 100, 1) . '%' : '0%' }}
                            </span>
                        </div>

                        <!-- Step 5: Conversion -->
                        <div class="flex-1 text-center relative z-10">
                            <div
                                class="w-16 h-16 mx-auto bg-emerald-100 rounded-full flex items-center justify-center mb-2 shadow-sm text-emerald-600">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <h4 class="font-bold text-sm text-slate-600 uppercase tracking-wide">Purchase</h4>
                            <p class="text-2xl font-black text-[#0f172a] mt-1">{{ $funnelData['conversion'] }}</p>
                        </div>
                    </div>
                </div>

                <!-- Recent Sessions -->
                <div
                    class="bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 overflow-hidden">
                    <div class="px-8 py-6 border-b border-slate-50">
                        <h3 class="text-lg font-extrabold text-[#0f172a] uppercase tracking-tight">Recent User Journeys
                        </h3>
                    </div>
                    <table class="w-full">
                        <thead class="bg-slate-50/50">
                            <tr class="text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                <th class="px-6 py-4 text-left">Session ID</th>
                                <th class="px-6 py-4 text-left">User</th>
                                <th class="px-6 py-4 text-left">IP Address</th>
                                <th class="px-6 py-4 text-left">Last Active</th>
                                <th class="px-6 py-4 text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-50">
                            @forelse($recentSessions as $session)
                                <tr class="hover:bg-slate-50/50 transition-colors">
                                    <td class="px-6 py-5 text-xs font-mono text-slate-500">
                                        {{ Str::limit($session->session_id, 8) }}</td>
                                    <td class="px-6 py-5 text-xs font-bold text-[#0f172a]">
                                        {{ $session->user ? $session->user->name : 'Guest' }}
                                    </td>
                                    <td class="px-6 py-5 text-xs text-slate-500">{{ $session->ip_address }}</td>
                                    <td class="px-6 py-5 text-xs text-slate-500">
                                        {{ \Carbon\Carbon::parse($session->last_active)->diffForHumans() }}</td>
                                    <td class="px-6 py-5 text-right">
                                        <a href="{{ route('admin.analytics.session', $session->session_id) }}"
                                            class="text-blue-600 hover:text-blue-800 font-bold text-xs uppercase tracking-wider">View
                                            Journey</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5"
                                        class="px-6 py-16 text-center text-slate-400 font-bold text-xs uppercase tracking-widest italic">
                                        No tracking data yet.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
</body>

</html>