<?php
// Debug script for chatbot settings
require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

$kernel->bootstrap();

$settings = App\Models\ChatbotSetting::first();

if ($settings) {
    echo "Found Settings:\n";
    echo "ID: " . $settings->id . "\n";
    echo "Name: " . $settings->name . "\n";
    echo "Welcome Message: " . $settings->welcome_message . "\n";
    echo "Color Scheme: " . $settings->color_scheme . "\n";
    echo "Is Active: " . ($settings->is_active ? 'true' : 'false') . "\n";
} else {
    echo "No settings found in database.\n";
}

$count = App\Models\ChatbotSetting::count();
echo "Total Rows: " . $count . "\n";
