<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmailTemplate;

class VideoConsultationEmailSeeder extends Seeder
{
    public function run()
    {
        $content = '
<div style="font-family: \'Outfit\', Arial, sans-serif; max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);">
    <!-- Header -->
    <div style="background: linear-gradient(135deg, #9B2D69 0%, #7a2454 100%); padding: 40px 20px; text-align: center;">
        <img src="{{ logo_url }}" alt="Hair Niche" style="height: 60px; width: auto; background: rgba(255,255,255,0.1); padding: 10px; border-radius: 8px;">
        <h1 style="color: #ffffff; margin-top: 20px; font-size: 24px; font-weight: 700; letter-spacing: 0.5px;">Video Consultation Request</h1>
    </div>

    <!-- Body -->
    <div style="padding: 40px 30px;">
        <p style="font-size: 16px; color: #374151; margin-bottom: 24px;">Dear {{ name }},</p>
        
        <p style="font-size: 16px; color: #4B5563; line-height: 1.6; margin-bottom: 24px;">
            Thank you for choosing Hair Niche! We have received your request for a personalized video consultation.
        </p>

        <div style="background-color: #FDF2F8; border-left: 4px solid #9B2D69; padding: 20px; margin-bottom: 30px; border-radius: 4px;">
            <p style="margin: 0; font-size: 15px; color: #9B2D69; font-weight: 600;">Requested Slot:</p>
            <p style="margin: 8px 0 0 0; font-size: 16px; color: #1F2937;"><strong>Date:</strong> {{ date }}<br><strong>Time:</strong> {{ time_slot }}</p>
        </div>

        <p style="font-size: 16px; color: #4B5563; line-height: 1.6; margin-bottom: 24px;">
            We will review your request and <strong>confirm your appointment shortly via email or WhatsApp message</strong>.
        </p>

        <p style="font-size: 16px; color: #4B5563;">
            Best Regards,<br>
            <strong style="color: #9B2D69;">The Hair Niche Team</strong>
        </p>
    </div>

    <!-- Footer -->
    <div style="background-color: #F9FAFB; padding: 24px; text-align: center; border-top: 1px solid #E5E7EB;">
        <p style="font-size: 12px; color: #9CA3AF; margin: 0;">&copy; {{ year }} Hair Niche. All rights reserved.</p>
        <p style="font-size: 12px; color: #9CA3AF; margin-top: 8px;">
            <a href="{{ app_url }}" style="color: #9B2D69; text-decoration: none;">Visit our website</a>
        </p>
    </div>
</div>';

        EmailTemplate::updateOrCreate(
            ['name' => 'Video Consultation Confirmation'],
            [
                'subject' => 'We received your Video Consultation Request - Hair Niche',
                'category' => 'Consultation',
                'target_role' => 'Clients',
                'content' => $content,
                'is_active' => true
            ]
        );
    }
}
