<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmailTemplate;

class UserEmailTemplateSeeder extends Seeder
{
    public function run()
    {
        $templates = [
            [
                'name' => 'Welcome Email',
                'subject' => 'Welcome to {{ app_name }}!',
                'category' => 'Welcome',
                'target_role' => 'Clients',
                'content' => '<h1>Welcome, {{ customer_name }}!</h1><p>We are thrilled to welcome you to {{ app_name }}. Enjoy shopping!</p>',
                'is_active' => true
            ],
            [
                'name' => 'Abandoned Cart Reminder',
                'subject' => 'You left something behind!',
                'category' => 'Cart Reminder',
                'target_role' => 'Clients',
                'content' => '<p>Hi {{ customer_name }},</p><p>We noticed you left some items in your cart:</p>{{ cart_items_summary }}<p><a href="{{ cart_url }}">Complete your purchase now!</a></p>',
                'is_active' => true
            ],
            [
                'name' => 'Wishlist Reminder',
                'subject' => 'Your wishlist items apply for discounts!',
                'category' => 'Wishlist Reminder',
                'target_role' => 'Clients',
                'content' => '<p>Hi {{ customer_name }},</p><p>These items from your wishlist are waiting for you:</p>{{ wishlist_items_summary }}<p><a href="{{ wishlist_url }}">Check them out</a></p>',
                'is_active' => true
            ]
        ];

        foreach ($templates as $t) {
            EmailTemplate::updateOrCreate(['name' => $t['name']], $t);
        }
    }
}
