<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Support\Str;

class SpicesSeeder extends Seeder
{
    public function run()
    {
        // 1. Ensure 'Spices' category exists
        $category = Category::firstOrCreate(
            ['name' => 'Spices'],
            ['slug' => 'spices', 'status' => true]
        );

        $spices = [
            'Turmeric Powder' => 'Bright yellow spice used for coloring and flavoring.',
            'Cumin Seeds' => 'Earthy, warm flavor, essential in Indian curries.',
            'Coriander Powder' => 'Fresh, citrusy aroma used in various dishes.',
            'Black Pepper' => 'The king of spices, adding heat and depth.',
            'Green Cardamom' => 'Sweet and aromatic, used in desserts and tea.',
            'Cloves' => 'Strong, sweet, and slight bitter spice.',
            'Cinnamon Sticks' => 'Sweet and woody flavor, great for baking.',
            'Fenugreek Seeds' => 'Bitter taste, used in pickles and curry powders.',
            'Mustard Seeds' => 'Pungent flavor, released when popped in oil.',
            'Red Chilli Powder' => 'Adds vibrant color and significant heat.',
        ];

        $prices = [150, 200, 180, 450, 1200, 900, 350, 120, 90, 280];
        $count = 0;

        foreach ($spices as $name => $desc) {
            $slug = Str::slug($name);
            $price = $prices[$count];

            Product::create([
                'category_id' => $category->id,
                'name' => $name,
                'slug' => $slug,
                'mrp' => $price + 50,
                'sp' => $price,
                'tax_code' => '5', // Spices usually 5%
                'short_description' => $desc,
                'long_description' => $desc . ' High quality organic ' . strtolower($name) . ' sourced directly from farms.',
                'dispatch_days' => 2,
                'country_origin' => 'India',
                'status' => true,
            ]);
            $count++;
        }
    }
}
