<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;
use App\Models\User;

class RolesSeeder extends Seeder
{
    public function run()
    {
        // Create Admin Role
        $adminRole = Role::firstOrCreate(
            ['name' => 'Admin'],
            ['description' => 'Administrator with full access', 'is_active' => true]
        );

        // Assign ALL permissions to Admin
        $permissions = Permission::all();
        $adminRole->permissions()->sync($permissions->pluck('id'));

        // Assign Admin role to the admin user
        $adminUser = User::where('email', 'admin@example.com')->first();
        if ($adminUser) {
            $adminUser->roles()->syncWithoutDetaching([$adminRole->id]);
        }

        // Create Delivery Agent Role (just in case it is needed for other logic)
        $deliveryRole = Role::firstOrCreate(
            ['name' => 'Delivery Agent'],
            ['description' => 'Delivery Personnel', 'is_active' => true]
        );
    }
}
