<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;

class ReturnPermissionsSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            'view_returns' => 'View Return Requests',
            'manage_returns' => 'Manage Returns (Approve/Reject)',
            'process_refunds' => 'Process Refunds',
            'view_refund_reports' => 'View Refund Reports',
        ];

        $createdPermissions = [];
        foreach ($permissions as $slug => $name) {
            $createdPermissions[] = Permission::firstOrCreate(['slug' => $slug], ['name' => $name]);
        }

        // Assign to Admin role
        $role = Role::where('name', 'Admin')->first();
        if ($role) {
            $role->permissions()->syncWithoutDetaching(collect($createdPermissions)->pluck('id'));
        }
    }
}
