<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionsSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            // Dashboard
            'view_dashboard' => 'View Admin Dashboard',

            // Products Management
            'view_products' => 'View Products',
            'create_products' => 'Create Products',
            'edit_products' => 'Edit Products',
            'delete_products' => 'Delete Products',

            // Categories Management
            'view_categories' => 'View Categories',
            'create_categories' => 'Create Categories',
            'edit_categories' => 'Edit Categories',
            'delete_categories' => 'Delete Categories',

            // Orders Management
            'view_orders' => 'View Orders',
            'manage_orders' => 'Manage Orders (Update/Process)',
            'delete_orders' => 'Delete Orders',

            // Customers/Clients
            'view_customers' => 'View Customers',
            'manage_customers' => 'Manage Customers',

            // Users (Staff/Admins)
            'view_users' => 'View System Users',
            'create_users' => 'Create System Users',
            'edit_users' => 'Edit System Users',
            'delete_users' => 'Delete System Users',

            // Roles & Permissions
            'view_roles' => 'View Roles',
            'create_roles' => 'Create Roles',
            'edit_roles' => 'Edit Roles',
            'delete_roles' => 'Delete Roles',

            // Blog Management
            'view_blogs' => 'View Blogs',
            'create_blogs' => 'Create Blogs',
            'edit_blogs' => 'Edit Blogs',
            'delete_blogs' => 'Delete Blogs',

            // Support Tickets
            'view_tickets' => 'View Support Tickets',
            'manage_tickets' => 'Manage/Reply Tickets',

            // Marketing (Coupons, Sliders, Banners, Subscribers)
            'view_coupons' => 'View Coupons',
            'manage_coupons' => 'Manage Coupons', // Create/Edit/Delete
            'manage_sliders' => 'Manage Sliders & Banners',
            'view_subscribers' => 'View Subscribers',

            // Delivery & Stores
            'manage_delivery_agents' => 'Manage Delivery Agents',
            'manage_stores' => 'Manage Stores',

            // General
            'view_reports' => 'View Reports',
            'view_contacts' => 'View Contact Messages',
            'manage_settings' => 'Manage System Settings',
            'manage_pages' => 'Manage Static Pages',
        ];

        foreach ($permissions as $slug => $name) {
            Permission::firstOrCreate(['slug' => $slug], ['name' => $name]);
        }
    }
}
