<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PaymentSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = \App\Models\GeneralSetting::firstOrNew();

        // Payment Options
        $settings->paypal_email = 'demo@lugani.com';
        $settings->paypal_link = 'https://paypal.me/luganidemo';

        $settings->upi_gpay_id = 'lugani@okicici';
        $settings->upi_phonepe_id = 'lugani@ybl';
        $settings->upi_bhim_id = 'lugani@upl';
        $settings->upi_cred_id = 'lugani@cred';
        $settings->upi_paytm_id = '9876543210@paytm';

        $settings->bank_name = 'HDFC Bank';
        $settings->bank_account_number = '123456789012';
        $settings->bank_ifsc = 'HDFC0001234';
        $settings->bank_beneficiary_name = 'Lugani Enterprises';
        $settings->bank_swift_code = 'HDFCINBB';

        // Gateways
        $settings->razorpay_enabled = true;
        $settings->razorpay_key_id = 'rzp_test_1234567890';
        $settings->razorpay_key_secret = 'razorpaysecret123';

        $settings->ccavenue_enabled = false;
        $settings->ccavenue_merchant_id = 'dummy_merchant';
        $settings->ccavenue_access_code = 'dummy_access';
        $settings->ccavenue_encryption_key = 'dummy_enc_key';

        // Admin Appearance
        $settings->admin_font_family = 'Inter';
        $settings->admin_font_size = '1rem';

        $settings->save();
    }
}
