<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            'About Us',
            'Cancellation Policy',
            'Data Deletion',
            'Privacy Policy',
            'Pricing & Refund Policy',
            'Shipping Policy',
            'Terms & Conditions',
        ];

        foreach ($pages as $title) {
            Page::firstOrCreate(
                ['title' => $title],
                [
                    'slug' => Str::slug($title),
                    'content' => '<h1>' . $title . '</h1><p>Content coming soon...</p>',
                ]
            );
        }
    }
}
