<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class HerbsProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $herbs = Category::where('name', 'Herbs')->first();
        $powder = Category::where('name', 'Herbs powder')->first();

        if (!$herbs || !$powder) {
            $this->command->error('Categories not found!');
            return;
        }

        $dummyProducts = [
            'Ashwagandha Root Powder',
            'Turmeric Root Powder',
            'Moringa Leaf Powder',
            'Triphala Powder',
            'Amla Powder',
            'Neem Leaf Powder',
            'Brahmi Powder',
            'Shatavari Powder',
            'Ginger Root Powder',
            'Giloy Guduchi Powder'
        ];

        foreach ($dummyProducts as $index => $name) {
            Product::create([
                'category_id' => $herbs->id,
                'subcategory_id' => $powder->id,
                'name' => $name,
                'slug' => Str::slug($name) . '-' . time() . '-' . $index,
                'mrp' => rand(200, 500),
                'sp' => rand(150, 199),
                'short_description' => "Premium quality natural {$name} for various health benefits.",
                'long_description' => "<p>Experience the purity of nature with our {$name}. Carefully sourced and processed to retain maximum potency. 100% natural and free from additives.</p>",
                'dispatch_days' => 2,
                'status' => true,
                'tax_code' => '5', // Herbs usually 5% or 12%
                'hsn_code' => '1211',
                'country_origin' => 'India',
            ]);
        }
    }
}
