<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\DeliveryAgent;
use App\Models\AgentDocument;
use App\Models\AgentVehicle;
use Illuminate\Support\Facades\Hash;
use Faker\Factory as Faker;

class DeliveryAgentSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        for ($i = 0; $i < 10; $i++) {
            // Create User
            $user = User::create([
                'name' => $faker->name,
                'email' => $faker->unique()->safeEmail,
                'password' => Hash::make('password'), // 12345678 or 'password'
                'is_active' => true,
            ]);

            // Create Agent Profile
            $agent = DeliveryAgent::create([
                'user_id' => $user->id,
                'phone' => $faker->phoneNumber,
                'address' => $faker->address,
                'profile_image' => null, // Placeholder or null
                'status' => true,
                // Legacy fields left null
            ]);

            // Add Documents
            $docTypes = ['Aadhar Card', 'PAN Card', 'Driving License'];
            $docCount = rand(2, 3);
            $selectedDocs = array_rand(array_flip($docTypes), $docCount);
            if (!is_array($selectedDocs))
                $selectedDocs = [$selectedDocs];

            foreach ($selectedDocs as $type) {
                AgentDocument::create([
                    'delivery_agent_id' => $agent->id,
                    'type' => $type,
                    'number' => strtoupper($faker->bothify('??#####??')),
                    'image_path' => 'agents/documents/dummy_doc.jpg', // Dummy path
                ]);
            }

            // Add Vehicles
            $vehicleTypes = ['Bike', 'Scooter', 'Van'];
            $count = rand(1, 2);
            $selectedTypes = array_rand(array_flip($vehicleTypes), $count);
            if (!is_array($selectedTypes))
                $selectedTypes = [$selectedTypes];

            foreach ($selectedTypes as $vType) {
                AgentVehicle::create([
                    'delivery_agent_id' => $agent->id,
                    'type' => $vType,
                    'vehicle_number' => strtoupper($faker->bothify('??-##-??-####')),
                    'model' => $faker->word . ' ' . $faker->year,
                    'is_primary' => false,
                ]);
            }
        }
    }
}
