<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BlogPostSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $posts = [
            [
                'title' => 'The Healing Power of Ayurveda: A Guide to Lugani Herbs',
                'slug' => 'healing-power-of-ayurveda-guide-to-lugani-herbs',
                'excerpt' => 'Discover how ancient Ayurvedic wisdom combined with modern purity can transform your health journey with Lugani Herbs.',
                'content' => '<p>Ayurveda, the "Science of Life," has been guiding humanity towards holistic wellness for thousands of years. At Lugani Herbs, we believe in preserving this ancient wisdom while delivering it in its purest form.</p>
                <h3>Why Choose Ayurveda?</h3>
                <p>Unlike modern medicine which often treats symptoms, Ayurveda focuses on the root cause of ailments and emphasizes preventive care. It balances the three doshas—Vata, Pitta, and Kapha—to ensure harmony within the body.</p>
                <h3>Our Commitment to Purity</h3>
                <p>Lugani Herbs sources only the finest quality ingredients. Our herbs are processed with minimal intervention to retain their natural potency. Whether it is our premium Ashwagandha or our revitalizing Chyawanprash, every product is a testament to our dedication to your well-being.</p>
                <p>Embrace the natural path to health with Lugani Herbs today.</p>',
                'image' => 'blog/ayurveda-healing.jpg',
                'status' => 'published',
                'published_at' => now()->subDays(10),
                'meta_title' => 'The Healing Power of Ayurveda | Lugani Herbs',
                'meta_description' => 'Explore the benefits of Ayurveda and how Lugani Herbs brings you the purest natural remedies for a healthier life.',
            ],
            [
                'title' => 'Top 5 Immunity-Boosting Herbs You Need This Winter',
                'slug' => 'top-5-immunity-boosting-herbs-winter',
                'excerpt' => 'Protect yourself and your family this winter season with these powerful immunity-boosting herbs from nature\'s pharmacy.',
                'content' => '<p>Winter brings cozy vibes but also the risk of colds and flu. Strengthening your immunity is your best defense. Here are the top 5 herbs you should incorporate into your routine:</p>
                <ol>
                    <li><strong>Tulsi (Holy Basil):</strong> Known as the "Queen of Herbs," Tulsi is a potent adaptogen that fights infections.</li>
                    <li><strong>Giloy:</strong> A powerhouse for immunity, Giloy helps in fighting recurrent fevers and infections.</li>
                    <li><strong>Amla:</strong> Rich in Vitamin C, Amla is essential for building resistance against common illnesses.</li>
                    <li><strong>Ashwagandha:</strong> Helps the body manage stress, which is crucial for maintaining a strong immune system.</li>
                    <li><strong>Turmeric (Curcumin):</strong> Its anti-inflammatory properties make it a winter essential.</li>
                </ol>
                <p>Find these and more in our extensive range at Lugani Herbs.</p>',
                'image' => 'blog/immunity-herbs.jpg',
                'status' => 'published',
                'published_at' => now()->subDays(7),
                'meta_title' => 'Top 5 Immunity Herbs for Winter | Lugani Herbs',
                'meta_description' => 'Boost your immunity this winter with Tulsi, Giloy, Amla, and more. Discover the best herbs to stay healthy.',
            ],
            [
                'title' => 'Understanding Chyawanprash: The Ancient Elixir for Modern Health',
                'slug' => 'understanding-chyawanprash-ancient-elixir',
                'excerpt' => 'Chyawanprash is more than just a sweet jam; it is a comprehensive health tonic. Learn why it should be a daily staple.',
                'content' => '<p>Chyawanprash is a traditional Ayurvedic formulation, often called the "Elixir of Life." It is a jam-like mixture of sugar, honey, ghee, Indian Gooseberry (Amla), jam, sesame oil, berries, and various herbs and spices.</p>
                <h3>Key Benefits:</h3>
                <ul>
                    <li><strong>Boosts Immunity:</strong> The high Vitamin C content from Amla strengthens the immune system.</li>
                    <li><strong>Improves Digestion:</strong> It aids in better absorption of nutrients and healthy digestion.</li>
                    <li><strong>Respiratory Health:</strong> Regular consumption protects against respiratory ailments.</li>
                    <li><strong>Anti-Aging:</strong> Its antioxidant properties help delay the signs of aging.</li>
                </ul>
                <p>Lugani Herbs\' Chyawanprash is made with the traditional recipe to ensure you get maximum benefits.</p>',
                'image' => 'blog/chyawanprash.jpg',
                'status' => 'published',
                'published_at' => now()->subDays(5),
                'meta_title' => 'Benefits of Chyawanprash | Lugani Herbs',
                'meta_description' => 'Learn about the incredible health benefits of Chyawanprash and why Lugani Herbs offers the best authentic blend.',
            ],
            [
                'title' => 'Ashwagandha: The Stress-Busting Superherb',
                'slug' => 'ashwagandha-stress-busting-superherb',
                'excerpt' => 'Feeling overwhelmed? Ashwagandha might be the natural solution you need to manage stress and anxiety effectively.',
                'content' => '<p>In today\'s fast-paced world, stress is a common companion. Ashwagandha, one of the most important herbs in Ayurveda, is classified as an "adaptogen," meaning it helps your body manage stress.</p>
                <h3>How It Helps:</h3>
                <ul>
                    <li><strong>Reduces Cortisol Levels:</strong> Ashwagandha is proven to lower the body\'s stress hormone.</li>
                    <li><strong>Improves Sleep:</strong> It promotes restful sleep and combats insomnia.</li>
                    <li><strong>Boosts Brain Function:</strong> It helps improve memory and cognitive function.</li>
                </ul>
                <p>Incorporate Lugani Herbs Ashwagandha powder or capsules into your daily routine for a calmer, more focused you.</p>',
                'image' => 'blog/ashwagandha.jpg',
                'status' => 'published',
                'published_at' => now()->subDays(3),
                'meta_title' => 'Ashwagandha for Stress Relief | Lugani Herbs',
                'meta_description' => 'Combat stress naturally with Ashwagandha. Discover its benefits for mental health and well-being with Lugani Herbs.',
            ],
            [
                'title' => 'Natural Skin Care: Harnessing the Power of Aloe Vera and Neem',
                'slug' => 'natural-skin-care-aloe-vera-neem',
                'excerpt' => 'Ditch the chemicals and embrace the glow with nature\'s best skin care ingredients: Aloe Vera and Neem.',
                'content' => '<p>Your skin deserves the gentle touch of nature. Chemical-laden products can often do more harm than good in the long run. Ayurveda recommends natural ingredients like Aloe Vera and Neem for radiant, healthy skin.</p>
                <h3>Aloe Vera: The Soother</h3>
                <p>Aloe Vera hydrates the skin without making it greasy. It is perfect for treating sunburn, acne, and dry skin. It contains antioxidants, enzymes, Vitamins A and C, and it is highly anti-inflammatory.</p>
                <h3>Neem: The Purifier</h3>
                <p>Neem is known for its antibacterial properties. It helps in clearing acne, scars, and pigmentation. It detoxifies the skin from within.</p>
                <p>Experience the purity of our herbal skin care range at Lugani Herbs.</p>',
                'image' => 'blog/skincare-herbs.jpg',
                'status' => 'published',
                'published_at' => now()->subDays(1),
                'meta_title' => 'Natural Skin Care with Aloe & Neem | Lugani Herbs',
                'meta_description' => 'Get glowing skin naturally with Aloe Vera and Neem. Learn about their benefits for a healthy skincare routine.',
            ],
        ];

        foreach ($posts as $post) {
            \App\Models\BlogPost::create($post);
        }
    }
}
