<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\ProductReview;
use App\Models\Product;
use Illuminate\Support\Facades\Hash;

class BangsReviewsSeeder extends Seeder
{
    public function run()
    {
        $customers = [
            ['name' => 'Ananya Sharma', 'email' => 'ananya.sharma@example.com'],
            ['name' => 'Priya Patel', 'email' => 'priya.patel@example.com'],
            ['name' => 'Sana Khan', 'email' => 'sana.khan@example.com'],
            ['name' => 'Riya Gupta', 'email' => 'riya.gupta@example.com'],
            ['name' => 'Ishani Verma', 'email' => 'ishani.verma@example.com'],
            ['name' => 'Meera Iyer', 'email' => 'meera.iyer@example.com'],
            ['name' => 'Aavya Reddy', 'email' => 'aavya.reddy@example.com'],
            ['name' => 'Tanvi Malhotra', 'email' => 'tanvi.malhotra@example.com'],
            ['name' => 'Kavya Singh', 'email' => 'kavya.singh@example.com'],
            ['name' => 'Shreya Das', 'email' => 'shreya.das@example.com'],
            ['name' => 'Neha Joshi', 'email' => 'neha.joshi@example.com'],
            ['name' => 'Aditi Rao', 'email' => 'aditi.rao@example.com'],
        ];

        $users = [];
        foreach ($customers as $customer) {
            $users[] = User::firstOrCreate(
                ['email' => $customer['email']],
                [
                    'name' => $customer['name'],
                    'password' => Hash::make('password'),
                ]
            );
        }

        $reviews = [
            // Product 38: Dense Bangs (Natural Black)
            [
                'product_id' => 38,
                'user_index' => 0,
                'rating' => 5,
                'comment' => 'Amazing quality! The black shade matches my hair perfectly. Looks very natural.'
            ],
            [
                'product_id' => 38,
                'user_index' => 1,
                'rating' => 4,
                'comment' => 'Very happy with this purchase. Easy to clip in and stays secure all day.'
            ],
            [
                'product_id' => 38,
                'user_index' => 2,
                'rating' => 5,
                'comment' => 'I love these bangs! They are thick and give me a complete makeover without cutting my hair.'
            ],
            [
                'product_id' => 38,
                'user_index' => 3,
                'rating' => 4,
                'comment' => 'Good product, but took a bit of time to blend it with my shorter hair.'
            ],

            // Product 39: Dense Bangs (Natural Brown)
            [
                'product_id' => 39,
                'user_index' => 4,
                'rating' => 5,
                'comment' => 'The brown color is so beautiful. It perfectly matches my highlights.'
            ],
            [
                'product_id' => 39,
                'user_index' => 5,
                'rating' => 5,
                'comment' => "Best hair extension I've bought so far. The quality is top-notch."
            ],
            [
                'product_id' => 39,
                'user_index' => 6,
                'rating' => 5,
                'comment' => "Very soft and natural looking. No one can tell I'm wearing extensions!"
            ],
            [
                'product_id' => 39,
                'user_index' => 7,
                'rating' => 4,
                'comment' => 'Exactly what I was looking for. Perfect for a quick style change.'
            ],

            // Product 40: Wispy Bangs
            [
                'product_id' => 40,
                'user_index' => 8,
                'rating' => 5,
                'comment' => 'These wispy bangs are so trendy! Love how they frame my face.'
            ],
            [
                'product_id' => 40,
                'user_index' => 9,
                'rating' => 5,
                'comment' => 'Very lightweight and comfortable. I forget I\'m even wearing them.'
            ],
            [
                'product_id' => 40,
                'user_index' => 10,
                'rating' => 4,
                'comment' => 'Great for a subtle look. Not too heavy, which is what I wanted.'
            ],
            [
                'product_id' => 40,
                'user_index' => 11,
                'rating' => 5,
                'comment' => 'Beautifully made. The wispy look is very soft and feminine.'
            ],
        ];

        foreach ($reviews as $reviewData) {
            ProductReview::create([
                'product_id' => $reviewData['product_id'],
                'user_id' => $users[$reviewData['user_index']]->id,
                'rating' => $reviewData['rating'],
                'comment' => $reviewData['comment'],
                'is_published' => true,
            ]);
        }
    }
}
