<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AdditionalProductsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $category = \App\Models\Category::firstOrCreate(
            ['slug' => 'herbs'],
            ['name' => 'Herbs', 'status' => true]
        );

        $subcategory = \App\Models\Category::firstOrCreate(
            ['slug' => 'herbs-powder', 'parent_id' => $category->id],
            ['name' => 'Herbs Powder', 'status' => true]
        );

        $products = [
            ['name' => 'Ashwagandha Powder', 'mrp' => 500, 'sp' => 450, 'short_description' => 'Organic Ashwagandha Root Powder'],
            ['name' => 'Triphala Powder', 'mrp' => 400, 'sp' => 350, 'short_description' => 'Ayurvedic Triphala Churna'],
            ['name' => 'Brahmi Powder', 'mrp' => 350, 'sp' => 300, 'short_description' => 'Memory Booster Brahmi'],
            ['name' => 'Shatavari Powder', 'mrp' => 600, 'sp' => 550, 'short_description' => 'Women Wellness Shatavari'],
            ['name' => 'Moringa Powder', 'mrp' => 300, 'sp' => 250, 'short_description' => 'Superfood Moringa Leaf Powder'],
            ['name' => ' नीम Powder (Neem)', 'mrp' => 250, 'sp' => 200, 'short_description' => 'Bitter Neem Powder for Skin'],
            ['name' => 'Amla Powder', 'mrp' => 200, 'sp' => 180, 'short_description' => 'Vitamin C Rich Amla'],
            ['name' => 'Tulsi Powder', 'mrp' => 220, 'sp' => 190, 'short_description' => 'Holy Basil Powder'],
            ['name' => 'Giloy Powder', 'mrp' => 280, 'sp' => 240, 'short_description' => 'Immunity Booster Giloy'],
            ['name' => 'Shikakai Powder', 'mrp' => 320, 'sp' => 290, 'short_description' => 'Natural Hair Cleanser'],
        ];

        foreach ($products as $p) {
            \App\Models\Product::create([
                'category_id' => $category->id,
                'subcategory_id' => $subcategory->id,
                'name' => $p['name'],
                'slug' => \Illuminate\Support\Str::slug($p['name']) . '-' . rand(1000, 9999),
                'mrp' => $p['mrp'],
                'sp' => $p['sp'],
                'short_description' => $p['short_description'],
                'long_description' => $p['short_description'] . ' - Detailed description here.',
                'dispatch_days' => 2,
                'tax_code' => '18',
                'status' => true,
            ]);
        }
    }
}
