<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('custom_offers', function (Blueprint $table) {
            $table->string('border_radius')->nullable()->default('0px')->after('placement_position');
            $table->string('box_shadow')->nullable()->default('none')->after('border_radius');
            $table->string('bg_color')->nullable()->default('#ffffff')->after('box_shadow');
            $table->string('heading_font_size')->nullable()->default('2rem')->after('bg_color');
            $table->string('heading_font_weight')->nullable()->default('700')->after('heading_font_size');
            $table->string('heading_color')->nullable()->default('#111827')->after('heading_font_weight');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('custom_offers', function (Blueprint $table) {
            $table->dropColumn([
                'border_radius',
                'box_shadow',
                'bg_color',
                'heading_font_size',
                'heading_font_weight',
                'heading_color',
            ]);
        });
    }
};
