<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('custom_offers', function (Blueprint $table) {
            $table->string('target_element')->nullable()->after('placement_pages');
            $table->string('placement_position')->default('after')->after('target_element'); // 'before', 'after', 'inside_start', 'inside_end'
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('custom_offers', function (Blueprint $table) {
            $table->dropColumn(['target_element', 'placement_position']);
        });
    }
};
