<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('layouts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('columns')->default(1);
            $table->timestamps();
        });

        // Seed default layouts
        DB::table('layouts')->insert([
            ['name' => 'Grid of 1', 'columns' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Grid of 2', 'columns' => 2, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Grid of 3', 'columns' => 3, 'created_at' => now(), 'updated_at' => now()],
        ]);

        Schema::create('custom_offers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('layout_id');
            $table->boolean('status')->default(true);
            $table->timestamps();

            $table->foreign('layout_id')->references('id')->on('layouts')->onDelete('cascade');
        });

        Schema::create('custom_offer_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('custom_offer_id');
            $table->string('banner_image');
            $table->string('redirect_url')->nullable();
            $table->string('alt_tag')->nullable();
            $table->integer('sort_order')->default(0);
            $table->timestamps();

            $table->foreign('custom_offer_id')->references('id')->on('custom_offers')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_offer_items');
        Schema::dropIfExists('custom_offers');
        Schema::dropIfExists('layouts');
    }
};
