<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chatbot_settings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->default('Assistant');
            $table->string('color_scheme')->default('#9B2D69');
            $table->boolean('is_active')->default(true);
            $table->text('welcome_message')->nullable();
            $table->text('system_prompt')->nullable();
            $table->timestamps();
        });

        Schema::create('chatbot_knowledge_bases', function (Blueprint $table) {
            $table->id();
            $table->string('topic')->nullable();
            $table->longText('question')->nullable();
            $table->longText('answer');
            $table->enum('type', ['manual', 'scraped', 'learned'])->default('manual');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chatbot_knowledge_bases');
        Schema::dropIfExists('chatbot_settings');
    }
};
